/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Candidate;
import com.google.genai.types.CitationMetadata;
import com.google.genai.types.Content;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.FinishReason;
import com.google.genai.types.GroundingMetadata;
import com.google.genai.types.LogprobsResult;
import com.google.genai.types.SafetyRating;
import com.google.genai.types.UrlContextMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Candidate
extends JsonSerializable {
    @JsonProperty(value="content")
    public abstract Optional<Content> content();

    @JsonProperty(value="citationMetadata")
    public abstract Optional<CitationMetadata> citationMetadata();

    @JsonProperty(value="finishMessage")
    public abstract Optional<String> finishMessage();

    @JsonProperty(value="tokenCount")
    public abstract Optional<Integer> tokenCount();

    @JsonProperty(value="finishReason")
    public abstract Optional<FinishReason> finishReason();

    @JsonProperty(value="avgLogprobs")
    public abstract Optional<Double> avgLogprobs();

    @JsonProperty(value="groundingMetadata")
    public abstract Optional<GroundingMetadata> groundingMetadata();

    @JsonProperty(value="index")
    public abstract Optional<Integer> index();

    @JsonProperty(value="logprobsResult")
    public abstract Optional<LogprobsResult> logprobsResult();

    @JsonProperty(value="safetyRatings")
    public abstract Optional<List<SafetyRating>> safetyRatings();

    @JsonProperty(value="urlContextMetadata")
    public abstract Optional<UrlContextMetadata> urlContextMetadata();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Candidate.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Candidate fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Candidate.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Candidate.Builder();
        }

        @JsonProperty(value="content")
        public abstract Builder content(Content var1);

        @CanIgnoreReturnValue
        public Builder content(Content.Builder contentBuilder) {
            return this.content(contentBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder content(Optional<Content> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearContent() {
            return this.content(Optional.empty());
        }

        @JsonProperty(value="citationMetadata")
        public abstract Builder citationMetadata(CitationMetadata var1);

        @CanIgnoreReturnValue
        public Builder citationMetadata(CitationMetadata.Builder citationMetadataBuilder) {
            return this.citationMetadata(citationMetadataBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder citationMetadata(Optional<CitationMetadata> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCitationMetadata() {
            return this.citationMetadata(Optional.empty());
        }

        @JsonProperty(value="finishMessage")
        public abstract Builder finishMessage(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder finishMessage(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFinishMessage() {
            return this.finishMessage(Optional.empty());
        }

        @JsonProperty(value="tokenCount")
        public abstract Builder tokenCount(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tokenCount(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTokenCount() {
            return this.tokenCount(Optional.empty());
        }

        @JsonProperty(value="finishReason")
        public abstract Builder finishReason(FinishReason var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder finishReason(Optional<FinishReason> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFinishReason() {
            return this.finishReason(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder finishReason(FinishReason.Known knownType) {
            return this.finishReason(new FinishReason(knownType));
        }

        @CanIgnoreReturnValue
        public Builder finishReason(String finishReason) {
            return this.finishReason(new FinishReason(finishReason));
        }

        @JsonProperty(value="avgLogprobs")
        public abstract Builder avgLogprobs(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder avgLogprobs(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAvgLogprobs() {
            return this.avgLogprobs(Optional.empty());
        }

        @JsonProperty(value="groundingMetadata")
        public abstract Builder groundingMetadata(GroundingMetadata var1);

        @CanIgnoreReturnValue
        public Builder groundingMetadata(GroundingMetadata.Builder groundingMetadataBuilder) {
            return this.groundingMetadata(groundingMetadataBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder groundingMetadata(Optional<GroundingMetadata> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGroundingMetadata() {
            return this.groundingMetadata(Optional.empty());
        }

        @JsonProperty(value="index")
        public abstract Builder index(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder index(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearIndex() {
            return this.index(Optional.empty());
        }

        @JsonProperty(value="logprobsResult")
        public abstract Builder logprobsResult(LogprobsResult var1);

        @CanIgnoreReturnValue
        public Builder logprobsResult(LogprobsResult.Builder logprobsResultBuilder) {
            return this.logprobsResult(logprobsResultBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder logprobsResult(Optional<LogprobsResult> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLogprobsResult() {
            return this.logprobsResult(Optional.empty());
        }

        @JsonProperty(value="safetyRatings")
        public abstract Builder safetyRatings(List<SafetyRating> var1);

        @CanIgnoreReturnValue
        public Builder safetyRatings(SafetyRating ... safetyRatings) {
            return this.safetyRatings(Arrays.asList(safetyRatings));
        }

        @CanIgnoreReturnValue
        public Builder safetyRatings(SafetyRating.Builder ... safetyRatingsBuilders) {
            return this.safetyRatings((List)Arrays.asList(safetyRatingsBuilders).stream().map(SafetyRating.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder safetyRatings(Optional<List<SafetyRating>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSafetyRatings() {
            return this.safetyRatings(Optional.empty());
        }

        @JsonProperty(value="urlContextMetadata")
        public abstract Builder urlContextMetadata(UrlContextMetadata var1);

        @CanIgnoreReturnValue
        public Builder urlContextMetadata(UrlContextMetadata.Builder urlContextMetadataBuilder) {
            return this.urlContextMetadata(urlContextMetadataBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder urlContextMetadata(Optional<UrlContextMetadata> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUrlContextMetadata() {
            return this.urlContextMetadata(Optional.empty());
        }

        public abstract Candidate build();
    }
}

