/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_BatchJob;
import com.google.genai.types.BatchJobDestination;
import com.google.genai.types.BatchJobSource;
import com.google.genai.types.CompletionStats;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.JobError;
import com.google.genai.types.JobState;
import java.time.Instant;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class BatchJob
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="displayName")
    public abstract Optional<String> displayName();

    @JsonProperty(value="state")
    public abstract Optional<JobState> state();

    @JsonProperty(value="error")
    public abstract Optional<JobError> error();

    @JsonProperty(value="createTime")
    public abstract Optional<Instant> createTime();

    @JsonProperty(value="startTime")
    public abstract Optional<Instant> startTime();

    @JsonProperty(value="endTime")
    public abstract Optional<Instant> endTime();

    @JsonProperty(value="updateTime")
    public abstract Optional<Instant> updateTime();

    @JsonProperty(value="model")
    public abstract Optional<String> model();

    @JsonProperty(value="src")
    public abstract Optional<BatchJobSource> src();

    @JsonProperty(value="dest")
    public abstract Optional<BatchJobDestination> dest();

    @JsonProperty(value="completionStats")
    public abstract Optional<CompletionStats> completionStats();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_BatchJob.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static BatchJob fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, BatchJob.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_BatchJob.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="displayName")
        public abstract Builder displayName(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder displayName(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDisplayName() {
            return this.displayName(Optional.empty());
        }

        @JsonProperty(value="state")
        public abstract Builder state(JobState var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder state(Optional<JobState> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearState() {
            return this.state(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder state(JobState.Known knownType) {
            return this.state(new JobState(knownType));
        }

        @CanIgnoreReturnValue
        public Builder state(String state) {
            return this.state(new JobState(state));
        }

        @JsonProperty(value="error")
        public abstract Builder error(JobError var1);

        @CanIgnoreReturnValue
        public Builder error(JobError.Builder errorBuilder) {
            return this.error(errorBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder error(Optional<JobError> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearError() {
            return this.error(Optional.empty());
        }

        @JsonProperty(value="createTime")
        public abstract Builder createTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder createTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCreateTime() {
            return this.createTime(Optional.empty());
        }

        @JsonProperty(value="startTime")
        public abstract Builder startTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder startTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearStartTime() {
            return this.startTime(Optional.empty());
        }

        @JsonProperty(value="endTime")
        public abstract Builder endTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder endTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEndTime() {
            return this.endTime(Optional.empty());
        }

        @JsonProperty(value="updateTime")
        public abstract Builder updateTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder updateTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUpdateTime() {
            return this.updateTime(Optional.empty());
        }

        @JsonProperty(value="model")
        public abstract Builder model(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder model(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearModel() {
            return this.model(Optional.empty());
        }

        @JsonProperty(value="src")
        public abstract Builder src(BatchJobSource var1);

        @CanIgnoreReturnValue
        public Builder src(BatchJobSource.Builder srcBuilder) {
            return this.src(srcBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder src(Optional<BatchJobSource> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSrc() {
            return this.src(Optional.empty());
        }

        @JsonProperty(value="dest")
        public abstract Builder dest(BatchJobDestination var1);

        @CanIgnoreReturnValue
        public Builder dest(BatchJobDestination.Builder destBuilder) {
            return this.dest(destBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder dest(Optional<BatchJobDestination> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDest() {
            return this.dest(Optional.empty());
        }

        @JsonProperty(value="completionStats")
        public abstract Builder completionStats(CompletionStats var1);

        @CanIgnoreReturnValue
        public Builder completionStats(CompletionStats.Builder completionStatsBuilder) {
            return this.completionStats(completionStatsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder completionStats(Optional<CompletionStats> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCompletionStats() {
            return this.completionStats(Optional.empty());
        }

        public abstract BatchJob build();
    }
}

