/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.Transcription;
import java.util.Optional;

final class AutoValue_Transcription
extends Transcription {
    private final Optional<String> text;
    private final Optional<Boolean> finished;

    private AutoValue_Transcription(Optional<String> text, Optional<Boolean> finished) {
        this.text = text;
        this.finished = finished;
    }

    @Override
    @JsonProperty(value="text")
    public Optional<String> text() {
        return this.text;
    }

    @Override
    @JsonProperty(value="finished")
    public Optional<Boolean> finished() {
        return this.finished;
    }

    public String toString() {
        return "Transcription{text=" + this.text + ", finished=" + this.finished + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Transcription) {
            Transcription that = (Transcription)o;
            return this.text.equals(that.text()) && this.finished.equals(that.finished());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.text.hashCode();
        h$ *= 1000003;
        return h$ ^= this.finished.hashCode();
    }

    @Override
    public Transcription.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Transcription.Builder {
        private Optional<String> text = Optional.empty();
        private Optional<Boolean> finished = Optional.empty();

        Builder() {
        }

        Builder(Transcription source) {
            this.text = source.text();
            this.finished = source.finished();
        }

        @Override
        public Transcription.Builder text(String text) {
            this.text = Optional.of(text);
            return this;
        }

        @Override
        Transcription.Builder text(Optional<String> text) {
            if (text == null) {
                throw new NullPointerException("Null text");
            }
            this.text = text;
            return this;
        }

        @Override
        public Transcription.Builder finished(boolean finished) {
            this.finished = Optional.of(finished);
            return this;
        }

        @Override
        Transcription.Builder finished(Optional<Boolean> finished) {
            if (finished == null) {
                throw new NullPointerException("Null finished");
            }
            this.finished = finished;
            return this;
        }

        @Override
        public Transcription build() {
            return new AutoValue_Transcription(this.text, this.finished);
        }
    }
}

