/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.HarmBlockMethod;
import com.google.genai.types.HarmBlockThreshold;
import com.google.genai.types.HarmCategory;
import com.google.genai.types.SafetySetting;
import java.util.Optional;

final class AutoValue_SafetySetting
extends SafetySetting {
    private final Optional<HarmCategory> category;
    private final Optional<HarmBlockMethod> method;
    private final Optional<HarmBlockThreshold> threshold;

    private AutoValue_SafetySetting(Optional<HarmCategory> category, Optional<HarmBlockMethod> method, Optional<HarmBlockThreshold> threshold) {
        this.category = category;
        this.method = method;
        this.threshold = threshold;
    }

    @Override
    @JsonProperty(value="category")
    public Optional<HarmCategory> category() {
        return this.category;
    }

    @Override
    @JsonProperty(value="method")
    public Optional<HarmBlockMethod> method() {
        return this.method;
    }

    @Override
    @JsonProperty(value="threshold")
    public Optional<HarmBlockThreshold> threshold() {
        return this.threshold;
    }

    public String toString() {
        return "SafetySetting{category=" + this.category + ", method=" + this.method + ", threshold=" + this.threshold + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SafetySetting) {
            SafetySetting that = (SafetySetting)o;
            return this.category.equals(that.category()) && this.method.equals(that.method()) && this.threshold.equals(that.threshold());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.category.hashCode();
        h$ *= 1000003;
        h$ ^= this.method.hashCode();
        h$ *= 1000003;
        return h$ ^= this.threshold.hashCode();
    }

    @Override
    public SafetySetting.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SafetySetting.Builder {
        private Optional<HarmCategory> category = Optional.empty();
        private Optional<HarmBlockMethod> method = Optional.empty();
        private Optional<HarmBlockThreshold> threshold = Optional.empty();

        Builder() {
        }

        Builder(SafetySetting source) {
            this.category = source.category();
            this.method = source.method();
            this.threshold = source.threshold();
        }

        @Override
        public SafetySetting.Builder category(HarmCategory category) {
            this.category = Optional.of(category);
            return this;
        }

        @Override
        SafetySetting.Builder category(Optional<HarmCategory> category) {
            if (category == null) {
                throw new NullPointerException("Null category");
            }
            this.category = category;
            return this;
        }

        @Override
        public SafetySetting.Builder method(HarmBlockMethod method) {
            this.method = Optional.of(method);
            return this;
        }

        @Override
        SafetySetting.Builder method(Optional<HarmBlockMethod> method) {
            if (method == null) {
                throw new NullPointerException("Null method");
            }
            this.method = method;
            return this;
        }

        @Override
        public SafetySetting.Builder threshold(HarmBlockThreshold threshold) {
            this.threshold = Optional.of(threshold);
            return this;
        }

        @Override
        SafetySetting.Builder threshold(Optional<HarmBlockThreshold> threshold) {
            if (threshold == null) {
                throw new NullPointerException("Null threshold");
            }
            this.threshold = threshold;
            return this;
        }

        @Override
        public SafetySetting build() {
            return new AutoValue_SafetySetting(this.category, this.method, this.threshold);
        }
    }
}

