/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.ReplayResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class AutoValue_ReplayResponse
extends ReplayResponse {
    private final Optional<Integer> statusCode;
    private final Optional<Map<String, String>> headers;
    private final Optional<List<Map<String, Object>>> bodySegments;
    private final Optional<List<Map<String, Object>>> sdkResponseSegments;

    private AutoValue_ReplayResponse(Optional<Integer> statusCode, Optional<Map<String, String>> headers, Optional<List<Map<String, Object>>> bodySegments, Optional<List<Map<String, Object>>> sdkResponseSegments) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.bodySegments = bodySegments;
        this.sdkResponseSegments = sdkResponseSegments;
    }

    @Override
    @JsonProperty(value="status_code")
    public Optional<Integer> statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonProperty(value="headers")
    public Optional<Map<String, String>> headers() {
        return this.headers;
    }

    @Override
    @JsonProperty(value="body_segments")
    public Optional<List<Map<String, Object>>> bodySegments() {
        return this.bodySegments;
    }

    @Override
    @JsonProperty(value="sdk_response_segments")
    public Optional<List<Map<String, Object>>> sdkResponseSegments() {
        return this.sdkResponseSegments;
    }

    public String toString() {
        return "ReplayResponse{statusCode=" + this.statusCode + ", headers=" + this.headers + ", bodySegments=" + this.bodySegments + ", sdkResponseSegments=" + this.sdkResponseSegments + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReplayResponse) {
            ReplayResponse that = (ReplayResponse)o;
            return this.statusCode.equals(that.statusCode()) && this.headers.equals(that.headers()) && this.bodySegments.equals(that.bodySegments()) && this.sdkResponseSegments.equals(that.sdkResponseSegments());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.statusCode.hashCode();
        h$ *= 1000003;
        h$ ^= this.headers.hashCode();
        h$ *= 1000003;
        h$ ^= this.bodySegments.hashCode();
        h$ *= 1000003;
        return h$ ^= this.sdkResponseSegments.hashCode();
    }

    @Override
    public ReplayResponse.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ReplayResponse.Builder {
        private Optional<Integer> statusCode = Optional.empty();
        private Optional<Map<String, String>> headers = Optional.empty();
        private Optional<List<Map<String, Object>>> bodySegments = Optional.empty();
        private Optional<List<Map<String, Object>>> sdkResponseSegments = Optional.empty();

        Builder() {
        }

        Builder(ReplayResponse source) {
            this.statusCode = source.statusCode();
            this.headers = source.headers();
            this.bodySegments = source.bodySegments();
            this.sdkResponseSegments = source.sdkResponseSegments();
        }

        @Override
        public ReplayResponse.Builder statusCode(Integer statusCode) {
            this.statusCode = Optional.of(statusCode);
            return this;
        }

        @Override
        ReplayResponse.Builder statusCode(Optional<Integer> statusCode) {
            if (statusCode == null) {
                throw new NullPointerException("Null statusCode");
            }
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public ReplayResponse.Builder headers(Map<String, String> headers) {
            this.headers = Optional.of(headers);
            return this;
        }

        @Override
        ReplayResponse.Builder headers(Optional<Map<String, String>> headers) {
            if (headers == null) {
                throw new NullPointerException("Null headers");
            }
            this.headers = headers;
            return this;
        }

        @Override
        public ReplayResponse.Builder bodySegments(List<Map<String, Object>> bodySegments) {
            this.bodySegments = Optional.of(bodySegments);
            return this;
        }

        @Override
        ReplayResponse.Builder bodySegments(Optional<List<Map<String, Object>>> bodySegments) {
            if (bodySegments == null) {
                throw new NullPointerException("Null bodySegments");
            }
            this.bodySegments = bodySegments;
            return this;
        }

        @Override
        public ReplayResponse.Builder sdkResponseSegments(List<Map<String, Object>> sdkResponseSegments) {
            this.sdkResponseSegments = Optional.of(sdkResponseSegments);
            return this;
        }

        @Override
        ReplayResponse.Builder sdkResponseSegments(Optional<List<Map<String, Object>>> sdkResponseSegments) {
            if (sdkResponseSegments == null) {
                throw new NullPointerException("Null sdkResponseSegments");
            }
            this.sdkResponseSegments = sdkResponseSegments;
            return this;
        }

        @Override
        public ReplayResponse build() {
            return new AutoValue_ReplayResponse(this.statusCode, this.headers, this.bodySegments, this.sdkResponseSegments);
        }
    }
}

