/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.ProxyOptions;
import com.google.genai.types.ProxyType;
import java.util.Optional;

final class AutoValue_ProxyOptions
extends ProxyOptions {
    private final Optional<ProxyType> type;
    private final Optional<String> host;
    private final Optional<Integer> port;
    private final Optional<String> username;
    private final Optional<String> password;

    private AutoValue_ProxyOptions(Optional<ProxyType> type, Optional<String> host, Optional<Integer> port, Optional<String> username, Optional<String> password) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    @Override
    @JsonProperty(value="type")
    public Optional<ProxyType> type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="host")
    public Optional<String> host() {
        return this.host;
    }

    @Override
    @JsonProperty(value="port")
    public Optional<Integer> port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="username")
    public Optional<String> username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="password")
    public Optional<String> password() {
        return this.password;
    }

    public String toString() {
        return "ProxyOptions{type=" + this.type + ", host=" + this.host + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProxyOptions) {
            ProxyOptions that = (ProxyOptions)o;
            return this.type.equals(that.type()) && this.host.equals(that.host()) && this.port.equals(that.port()) && this.username.equals(that.username()) && this.password.equals(that.password());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.host.hashCode();
        h$ *= 1000003;
        h$ ^= this.port.hashCode();
        h$ *= 1000003;
        h$ ^= this.username.hashCode();
        h$ *= 1000003;
        return h$ ^= this.password.hashCode();
    }

    @Override
    public ProxyOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ProxyOptions.Builder {
        private Optional<ProxyType> type = Optional.empty();
        private Optional<String> host = Optional.empty();
        private Optional<Integer> port = Optional.empty();
        private Optional<String> username = Optional.empty();
        private Optional<String> password = Optional.empty();

        Builder() {
        }

        Builder(ProxyOptions source) {
            this.type = source.type();
            this.host = source.host();
            this.port = source.port();
            this.username = source.username();
            this.password = source.password();
        }

        @Override
        public ProxyOptions.Builder type(ProxyType type) {
            this.type = Optional.of(type);
            return this;
        }

        @Override
        ProxyOptions.Builder type(Optional<ProxyType> type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public ProxyOptions.Builder host(String host) {
            this.host = Optional.of(host);
            return this;
        }

        @Override
        ProxyOptions.Builder host(Optional<String> host) {
            if (host == null) {
                throw new NullPointerException("Null host");
            }
            this.host = host;
            return this;
        }

        @Override
        public ProxyOptions.Builder port(Integer port) {
            this.port = Optional.of(port);
            return this;
        }

        @Override
        ProxyOptions.Builder port(Optional<Integer> port) {
            if (port == null) {
                throw new NullPointerException("Null port");
            }
            this.port = port;
            return this;
        }

        @Override
        public ProxyOptions.Builder username(String username) {
            this.username = Optional.of(username);
            return this;
        }

        @Override
        ProxyOptions.Builder username(Optional<String> username) {
            if (username == null) {
                throw new NullPointerException("Null username");
            }
            this.username = username;
            return this;
        }

        @Override
        public ProxyOptions.Builder password(String password) {
            this.password = Optional.of(password);
            return this;
        }

        @Override
        ProxyOptions.Builder password(Optional<String> password) {
            if (password == null) {
                throw new NullPointerException("Null password");
            }
            this.password = password;
            return this;
        }

        @Override
        public ProxyOptions build() {
            return new AutoValue_ProxyOptions(this.type, this.host, this.port, this.username, this.password);
        }
    }
}

