/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_ApiKeyConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpElementLocation;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ApiKeyConfig
extends JsonSerializable {
    @JsonProperty(value="apiKeySecret")
    public abstract Optional<String> apiKeySecret();

    @JsonProperty(value="apiKeyString")
    public abstract Optional<String> apiKeyString();

    @JsonProperty(value="httpElementLocation")
    public abstract Optional<HttpElementLocation> httpElementLocation();

    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_ApiKeyConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static ApiKeyConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, ApiKeyConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_ApiKeyConfig.Builder();
        }

        @JsonProperty(value="apiKeySecret")
        public abstract Builder apiKeySecret(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder apiKeySecret(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearApiKeySecret() {
            return this.apiKeySecret(Optional.empty());
        }

        @JsonProperty(value="apiKeyString")
        public abstract Builder apiKeyString(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder apiKeyString(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearApiKeyString() {
            return this.apiKeyString(Optional.empty());
        }

        @JsonProperty(value="httpElementLocation")
        public abstract Builder httpElementLocation(HttpElementLocation var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpElementLocation(Optional<HttpElementLocation> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpElementLocation() {
            return this.httpElementLocation(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder httpElementLocation(HttpElementLocation.Known knownType) {
            return this.httpElementLocation(new HttpElementLocation(knownType));
        }

        @CanIgnoreReturnValue
        public Builder httpElementLocation(String httpElementLocation) {
            return this.httpElementLocation(new HttpElementLocation(httpElementLocation));
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        public abstract ApiKeyConfig build();
    }
}

