/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.api.core.InternalApi;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.genai.ApiClient;
import com.google.genai.JsonSerializable;
import com.google.genai.types.Blob;
import com.google.genai.types.Content;
import com.google.genai.types.File;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.GeneratedVideo;
import com.google.genai.types.JobState;
import com.google.genai.types.Metric;
import com.google.genai.types.Part;
import com.google.genai.types.PrebuiltVoiceConfig;
import com.google.genai.types.Schema;
import com.google.genai.types.SpeechConfig;
import com.google.genai.types.Tool;
import com.google.genai.types.Video;
import com.google.genai.types.VoiceConfig;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

@InternalApi
public final class Transformers {
    private static final Logger logger = Logger.getLogger(Transformers.class.getName());

    private Transformers() {
    }

    public static String tModel(ApiClient apiClient, Object origin) {
        String model;
        if (origin == null) {
            throw new IllegalArgumentException("model is required.");
        }
        if (origin instanceof String) {
            model = (String)origin;
        } else if (origin instanceof JsonNode) {
            model = JsonSerializable.toJsonString((JsonNode)origin);
            model = model.replace("\"", "");
        } else {
            throw new IllegalArgumentException("Unsupported model type: " + origin.getClass());
        }
        if (model.isEmpty()) {
            throw new IllegalArgumentException("model is required.");
        }
        if (model.contains("..") || model.contains("?") || model.contains("&")) {
            throw new IllegalArgumentException("invalid model parameter.");
        }
        if (apiClient.vertexAI()) {
            if (model.startsWith("publishers/") || model.startsWith("projects/") || model.startsWith("models/")) {
                return model;
            }
            if (model.contains("/")) {
                String[] parts = model.split("/", 2);
                return String.format("publishers/%s/models/%s", parts[0], parts[1]);
            }
            return "publishers/google/models/" + model;
        }
        if (model.startsWith("models/") || model.startsWith("tunedModels/")) {
            return model;
        }
        return "models/" + model;
    }

    public static String tModelsUrl(ApiClient apiClient, @Nullable Object baseModels) {
        if (baseModels == null) {
            return apiClient.vertexAI() ? "publishers/google/models" : "models";
        }
        if (!(baseModels instanceof JsonNode)) {
            throw new IllegalArgumentException("Unsupported response type: " + baseModels.getClass());
        }
        if (((JsonNode)baseModels).asBoolean()) {
            return apiClient.vertexAI() ? "publishers/google/models" : "models";
        }
        return apiClient.vertexAI() ? "models" : "tunedModels";
    }

    public static @Nullable JsonNode tExtractModels(Object origin) {
        if (origin == null) {
            return null;
        }
        if (!(origin instanceof JsonNode)) {
            throw new IllegalArgumentException("Unsupported response type: " + origin.getClass());
        }
        JsonNode response = (JsonNode)origin;
        JsonNode models = response.get("models");
        if (models != null) {
            return models;
        }
        models = response.get("tunedModels");
        if (models != null) {
            return models;
        }
        models = response.get("publisherModels");
        if (models != null) {
            return models;
        }
        if (response.get("httpHeaders") == null || response.get("jsonPayload") != null) {
            logger.warning("Cannot determine the models type for response: " + response.toPrettyString());
        }
        return JsonSerializable.objectMapper.createArrayNode();
    }

    public static Object tContents(Object origin) {
        return origin;
    }

    public static ImmutableList<Content> tContents(String text) {
        Preconditions.checkNotNull((Object)text, (Object)"text cannot be null");
        return ImmutableList.of((Object)Content.fromParts(Part.fromText(text)));
    }

    public static ImmutableList<Content> tContents(Content content) {
        Preconditions.checkNotNull((Object)content, (Object)"text cannot be null");
        return ImmutableList.of((Object)content);
    }

    public static Content tContent(Object content) {
        if (content == null) {
            return null;
        }
        if (content instanceof String) {
            return Content.fromParts(Part.fromText((String)content));
        }
        if (content instanceof Content) {
            return (Content)content;
        }
        if (content instanceof JsonNode) {
            return JsonSerializable.fromJsonNode((JsonNode)content, Content.class);
        }
        throw new IllegalArgumentException("Unsupported content type: " + content.getClass());
    }

    public static Schema tSchema(Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof Schema) {
            return (Schema)origin;
        }
        if (origin instanceof JsonNode) {
            return JsonSerializable.fromJsonNode((JsonNode)origin, Schema.class);
        }
        throw new IllegalArgumentException("Unsupported schema type: " + origin.getClass());
    }

    public static SpeechConfig tSpeechConfig(Object speechConfig) {
        if (speechConfig == null) {
            return null;
        }
        if (speechConfig instanceof String) {
            return SpeechConfig.builder().voiceConfig(VoiceConfig.builder().prebuiltVoiceConfig(PrebuiltVoiceConfig.builder().voiceName((String)speechConfig).build()).build()).build();
        }
        if (speechConfig instanceof SpeechConfig) {
            return (SpeechConfig)speechConfig;
        }
        if (speechConfig instanceof JsonNode) {
            return JsonSerializable.fromJsonNode((JsonNode)speechConfig, SpeechConfig.class);
        }
        throw new IllegalArgumentException("Unsupported speechConfig type:" + speechConfig.getClass());
    }

    public static @Nullable SpeechConfig tLiveSpeechConfig(Object origin) {
        SpeechConfig speechConfig;
        if (origin == null) {
            return null;
        }
        if (origin instanceof SpeechConfig) {
            speechConfig = (SpeechConfig)origin;
        } else if (origin instanceof JsonNode) {
            speechConfig = JsonSerializable.fromJsonNode((JsonNode)origin, SpeechConfig.class);
        } else {
            throw new IllegalArgumentException("Unsupported speechConfig type:" + origin.getClass());
        }
        if (speechConfig.multiSpeakerVoiceConfig().isPresent()) {
            throw new IllegalArgumentException("multiSpeakerVoiceConfig is not supported in the live API.");
        }
        return speechConfig;
    }

    public static Object tTools(Object origin) {
        return origin;
    }

    public static Tool tTool(Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof Tool) {
            Tool tool = (Tool)origin;
            if (!tool.functions().isPresent()) {
                return tool;
            }
            ArrayList<FunctionDeclaration> combinedFunctionDeclarations = new ArrayList<FunctionDeclaration>();
            for (Method method : tool.functions().get()) {
                combinedFunctionDeclarations.add(FunctionDeclaration.fromMethod(method, new String[0]));
            }
            if (tool.functionDeclarations().isPresent()) {
                combinedFunctionDeclarations.addAll((Collection)tool.functionDeclarations().get());
            }
            ObjectNode toolNode = (ObjectNode)JsonSerializable.objectMapper.valueToTree((Object)tool);
            toolNode.remove("functions");
            toolNode.set("functionDeclarations", JsonSerializable.objectMapper.valueToTree(combinedFunctionDeclarations));
            return JsonSerializable.fromJsonNode((JsonNode)toolNode, Tool.class);
        }
        if (origin instanceof JsonNode) {
            return Transformers.tTool(JsonSerializable.objectMapper.convertValue((Object)((JsonNode)origin), (TypeReference)new TypeReference<Tool>(){}));
        }
        throw new IllegalArgumentException("Unsupported tool type: " + origin.getClass());
    }

    public static ArrayNode tBlobs(Object origin) {
        JsonNode inputNode;
        if (!(origin instanceof JsonNode)) {
            origin = JsonSerializable.toJsonNode(origin);
        }
        if ((inputNode = (JsonNode)origin).isArray()) {
            return (ArrayNode)inputNode;
        }
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        arrayNode.add(JsonSerializable.toJsonNode(Transformers.tBlob(origin)));
        return arrayNode;
    }

    public static Blob tBlob(Object blob) {
        if (blob instanceof JsonNode) {
            blob = JsonSerializable.objectMapper.convertValue((Object)((JsonNode)blob), (TypeReference)new TypeReference<Blob>(){});
        }
        if (blob instanceof Blob) {
            return (Blob)blob;
        }
        throw new IllegalArgumentException("Unsupported blob type: " + blob.getClass());
    }

    public static Blob tImageBlob(Object blob) {
        Blob transformedBlob = Transformers.tBlob(blob);
        if (transformedBlob.mimeType().isPresent() && transformedBlob.mimeType().get().startsWith("image/")) {
            return transformedBlob;
        }
        throw new IllegalArgumentException("Unsupported mime type for image blob: " + transformedBlob.mimeType().orElse("null"));
    }

    public static Blob tAudioBlob(Object blob) {
        Blob transformedBlob = Transformers.tBlob(blob);
        if (transformedBlob.mimeType().isPresent() && transformedBlob.mimeType().get().startsWith("audio/")) {
            return transformedBlob;
        }
        throw new IllegalArgumentException("Unsupported mime type for audio blob: " + transformedBlob.mimeType().orElse("null"));
    }

    public static Object tBytes(Object origin) {
        return origin;
    }

    public static String tCachedContentName(ApiClient apiClient, Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof String) {
            return Transformers.getResourceName(apiClient, (String)origin, "cachedContents");
        }
        if (origin instanceof JsonNode) {
            String cachedContentName = JsonSerializable.toJsonString((JsonNode)origin);
            cachedContentName = cachedContentName.replace("\"", "");
            return Transformers.getResourceName(apiClient, cachedContentName, "cachedContents");
        }
        throw new IllegalArgumentException("Unsupported cached content name type: " + origin.getClass());
    }

    public static @Nullable List<Object> tContentsForEmbed(ApiClient apiClient, Object origin) {
        List contents;
        if (origin == null) {
            return null;
        }
        if (origin instanceof List) {
            contents = (List)origin;
        } else if (origin instanceof JsonNode) {
            contents = (List)JsonSerializable.objectMapper.convertValue((Object)((JsonNode)origin), (TypeReference)new TypeReference<List<Content>>(){});
        } else {
            throw new IllegalArgumentException("Unsupported contents type: " + origin.getClass());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Content content : contents) {
            if (!apiClient.vertexAI()) {
                result.add(content);
                continue;
            }
            for (Part part : content.parts().orElse((List<Part>)ImmutableList.of())) {
                part.text().ifPresent(result::add);
            }
        }
        return result;
    }

    public static @Nullable String tCachesModel(ApiClient apiClient, Object origin) {
        String model = Transformers.tModel(apiClient, origin);
        if (model == null) {
            return null;
        }
        if (apiClient.vertexAI()) {
            if (model.startsWith("publishers/")) {
                return String.format("projects/%s/locations/%s/%s", apiClient.project(), apiClient.location(), model);
            }
            if (model.startsWith("models/")) {
                return String.format("projects/%s/locations/%s/publishers/google/%s", apiClient.project(), apiClient.location(), model);
            }
        }
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @Nullable String tFileName(Object origin) {
        String name = null;
        if (origin instanceof String) {
            name = (String)origin;
        } else if (origin instanceof File) {
            name = ((File)origin).name().orElseThrow(() -> new IllegalArgumentException("File name is required."));
        } else if (origin instanceof Video) {
            name = ((Video)origin).uri().orElse(null);
            if (name == null) {
                return null;
            }
        } else if (origin instanceof GeneratedVideo) {
            Video video = ((GeneratedVideo)origin).video().orElseThrow(() -> new IllegalArgumentException("Video is required."));
            name = video.uri().orElse(null);
            if (name == null) {
                return null;
            }
        } else {
            if (!(origin instanceof TextNode)) throw new IllegalArgumentException("Unsupported file name type: " + origin.getClass());
            name = ((TextNode)origin).textValue();
        }
        if (name.startsWith("https://")) {
            String suffix = name.split("files/")[1];
            Pattern pattern = Pattern.compile("[a-z0-9]+");
            Matcher matcher = pattern.matcher(suffix);
            if (!matcher.find()) throw new IllegalArgumentException("Could not extract file name from " + name);
            return matcher.group();
        }
        if (!name.startsWith("files/")) return name;
        return name.split("files/")[1];
    }

    public static JobState tTuningJobStatus(Object origin) {
        String status;
        if (origin instanceof String) {
            status = (String)origin;
        } else if (origin instanceof TextNode) {
            status = ((TextNode)origin).textValue();
        } else {
            throw new IllegalArgumentException("Unsupported status type: " + origin.getClass());
        }
        switch (status) {
            case "STATE_UNSPECIFIED": {
                return new JobState(JobState.Known.JOB_STATE_UNSPECIFIED);
            }
            case "CREATING": {
                return new JobState(JobState.Known.JOB_STATE_RUNNING);
            }
            case "ACTIVE": {
                return new JobState(JobState.Known.JOB_STATE_SUCCEEDED);
            }
            case "FAILED": {
                return new JobState(JobState.Known.JOB_STATE_FAILED);
            }
        }
        return new JobState(status);
    }

    private static String getResourceName(ApiClient apiClient, String resourceName, String resourcePrefix) {
        boolean shouldPrependCollectionIdentifier;
        boolean bl = shouldPrependCollectionIdentifier = !resourceName.startsWith(resourcePrefix + "/") && Transformers.countCharInAString(String.format("%s/%s", resourcePrefix, resourceName), '/') == 1;
        if (apiClient.vertexAI()) {
            if (resourceName.startsWith("projects/")) {
                return resourceName;
            }
            if (resourceName.startsWith("locations/")) {
                return String.format("projects/%s/%s", apiClient.project(), resourceName);
            }
            if (resourceName.startsWith(resourcePrefix + "/")) {
                return String.format("projects/%s/locations/%s/%s", apiClient.project(), apiClient.location(), resourceName);
            }
            if (shouldPrependCollectionIdentifier) {
                return String.format("projects/%s/locations/%s/%s/%s", apiClient.project(), apiClient.location(), resourcePrefix, resourceName);
            }
            return resourceName;
        }
        if (shouldPrependCollectionIdentifier) {
            return String.format("%s/%s", resourcePrefix, resourceName);
        }
        return resourceName;
    }

    private static int countCharInAString(String string, char charToCount) {
        int count = 0;
        for (char c : string.toCharArray()) {
            if (c != charToCount) continue;
            ++count;
        }
        return count;
    }

    public static Object tBatchJobSource(Object src) {
        return src;
    }

    public static Object tBatchJobDestination(Object dest) {
        return dest;
    }

    public static Object tRecvBatchJobDestination(Object dest) {
        return dest;
    }

    public static String tBatchJobName(ApiClient apiClient, Object name) {
        String nameStr;
        if (name instanceof String) {
            nameStr = (String)name;
        } else if (name instanceof JsonNode) {
            nameStr = JsonSerializable.toJsonString((JsonNode)name);
            nameStr = nameStr.replace("\"", "");
        } else {
            throw new IllegalArgumentException("Unsupported batch job name type: " + name.getClass());
        }
        if (apiClient.vertexAI()) {
            String fullBatchName = Transformers.getResourceName(apiClient, nameStr, "batchPredictionJobs");
            if (fullBatchName != null) {
                String[] parts = fullBatchName.split("/");
                String jobId = parts[parts.length - 1];
                Pattern pattern = Pattern.compile("[0-9]+");
                Matcher matcher = pattern.matcher(jobId);
                if (matcher.find() && parts.length == 6) {
                    return jobId;
                }
            }
            throw new IllegalArgumentException(String.format("Invalid batch job name: %s. Expected format like 'projects/123/locations/us-central1/batchPredictionJobs/456' or '456'.", nameStr));
        }
        if ((nameStr = nameStr.replace("\"", "")).startsWith("batches/")) {
            return nameStr.split("/")[1];
        }
        throw new IllegalArgumentException(String.format("Invalid batch job name: %s. Expected format like 'batches/id'", nameStr));
    }

    public static Object tJobState(Object state) {
        String stateStr;
        if (state instanceof String) {
            stateStr = (String)state;
        } else if (state instanceof JsonNode) {
            stateStr = JsonSerializable.toJsonString(state);
            stateStr = stateStr.replace("\"", "");
        } else {
            throw new IllegalArgumentException("Unsupported job state type: " + state.getClass());
        }
        switch (stateStr) {
            case "BATCH_STATE_UNSPECIFIED": {
                return JobState.Known.JOB_STATE_UNSPECIFIED;
            }
            case "BATCH_STATE_PENDING": {
                return JobState.Known.JOB_STATE_PENDING;
            }
            case "BATCH_STATE_RUNNING": {
                return JobState.Known.JOB_STATE_RUNNING;
            }
            case "BATCH_STATE_SUCCEEDED": {
                return JobState.Known.JOB_STATE_SUCCEEDED;
            }
            case "BATCH_STATE_FAILED": {
                return JobState.Known.JOB_STATE_FAILED;
            }
            case "BATCH_STATE_CANCELLED": {
                return JobState.Known.JOB_STATE_CANCELLED;
            }
            case "BATCH_STATE_EXPIRED": {
                return JobState.Known.JOB_STATE_EXPIRED;
            }
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateJsonNode(ObjectNode currentObject, String keyToSet, JsonNode valueNode) {
        JsonNode existingData = currentObject.get(keyToSet);
        if (existingData != null) {
            if (valueNode == null || valueNode.isNull() || valueNode.isEmpty()) {
                return;
            }
            if (valueNode.equals((Object)existingData)) {
                return;
            }
            if (!existingData.isObject() || !valueNode.isObject()) throw new IllegalArgumentException("Cannot set value for an existing key. Key: " + keyToSet + "; Existing value: " + existingData + "; New value: " + valueNode);
            ((ObjectNode)existingData).setAll((ObjectNode)valueNode);
            return;
        } else {
            currentObject.set(keyToSet, valueNode);
        }
    }

    public static String camelToSnake(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static ArrayNode tMetrics(Object metrics) {
        if (metrics == null) {
            return JsonNodeFactory.instance.arrayNode();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        List metricsList = (List)objectMapper.convertValue(metrics, (TypeReference)new TypeReference<List<Metric>>(){});
        ArrayList<ObjectNode> metricsPayload = new ArrayList<ObjectNode>();
        for (Metric metricObj : metricsList) {
            String metricName;
            JsonNode metric = JsonSerializable.toJsonNode(metricObj);
            ObjectNode metricPayloadItem = JsonNodeFactory.instance.objectNode();
            ArrayNode aggregationMetrics = JsonNodeFactory.instance.arrayNode();
            aggregationMetrics.add("AVERAGE");
            aggregationMetrics.add("STANDARD_DEVIATION");
            metricPayloadItem.set("aggregation_metrics", (JsonNode)aggregationMetrics);
            String string = metricName = metric.has("name") ? metric.get("name").asText().toLowerCase(Locale.ROOT) : "";
            if (metricName.equals("exact_match")) {
                metricPayloadItem.set("exact_match_spec", (JsonNode)JsonNodeFactory.instance.objectNode());
            } else if (metricName.equals("bleu")) {
                metricPayloadItem.set("bleu_spec", (JsonNode)JsonNodeFactory.instance.objectNode());
            } else if (metricName.startsWith("rouge")) {
                String rougeType = metricName.replace("_", "");
                ObjectNode rougeSpec = JsonNodeFactory.instance.objectNode();
                rougeSpec.put("rouge_type", rougeType);
                metricPayloadItem.set("rouge_spec", (JsonNode)rougeSpec);
            } else if (metric.has("promptTemplate") && metric.get("promptTemplate").isTextual()) {
                ObjectNode pointwiseSpec = JsonNodeFactory.instance.objectNode();
                pointwiseSpec.set("metric_prompt_template", metric.get("promptTemplate"));
                if (metric.has("judgeModelSystemInstruction")) {
                    pointwiseSpec.set("system_instruction", metric.get("judgeModelSystemInstruction"));
                }
                if (metric.has("returnRawOutput")) {
                    ObjectNode customOutputFormatConfig = JsonNodeFactory.instance.objectNode();
                    customOutputFormatConfig.set("return_raw_output", metric.get("returnRawOutput"));
                    pointwiseSpec.set("custom_output_format_config", (JsonNode)customOutputFormatConfig);
                }
                metricPayloadItem.set("pointwise_metric_spec", (JsonNode)pointwiseSpec);
            } else {
                throw new IllegalArgumentException("Unsupported metric type or invalid metric name: " + metricName);
            }
            metricsPayload.add(metricPayloadItem);
        }
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        for (ObjectNode node : metricsPayload) {
            arrayNode.add((JsonNode)node);
        }
        return arrayNode;
    }
}

