/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.Common;
import com.google.genai.JsonSerializable;
import com.google.genai.TokensConverters;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.AuthToken;
import com.google.genai.types.CreateAuthTokenConfig;
import com.google.genai.types.CreateAuthTokenParameters;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import okhttp3.ResponseBody;

public class Tokens {
    private final ApiClient apiClient;

    Tokens(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    static String getFieldMasks(ObjectNode setup) {
        ArrayList<String> fields = new ArrayList<String>();
        Iterator fieldsIterator = setup.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)fieldsIterator.next();
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isObject() && value.size() > 0) {
                Iterator subKeys = value.fieldNames();
                while (subKeys.hasNext()) {
                    String kk = (String)subKeys.next();
                    fields.add(key + "." + kk);
                }
                continue;
            }
            fields.add(key);
        }
        return String.join((CharSequence)",", fields);
    }

    ObjectNode convertBidiSetupToTokenSetup(ObjectNode body, CreateAuthTokenConfig config) {
        ObjectNode transformedBody = body.deepCopy();
        ObjectNode setupForMaskGeneration = null;
        JsonNode bidiVal = body.get("bidiGenerateContentSetup");
        if (bidiVal != null && bidiVal.get("setup") != null) {
            JsonNode innerSetup = bidiVal.get("setup");
            if (innerSetup != null) {
                transformedBody.put("bidiGenerateContentSetup", innerSetup);
                setupForMaskGeneration = (ObjectNode)innerSetup;
            }
        } else {
            transformedBody.remove("bidiGenerateContentSetup");
        }
        JsonNode preExistingFieldMask = body.get("fieldMask");
        ArrayList<String> preExistingFieldMaskList = new ArrayList<String>();
        if (preExistingFieldMask != null && preExistingFieldMask.isArray()) {
            for (JsonNode element : preExistingFieldMask) {
                if (!element.isTextual()) continue;
                preExistingFieldMaskList.add(element.asText());
            }
        }
        if (setupForMaskGeneration != null) {
            boolean preExistingValid;
            String generatedMaskFromBidi = Tokens.getFieldMasks(setupForMaskGeneration);
            boolean configLockExists = config != null && config.lockAdditionalFields().isPresent();
            boolean bl = preExistingValid = preExistingFieldMaskList != null && !preExistingFieldMaskList.isEmpty();
            if (configLockExists && config.lockAdditionalFields().isPresent() && config.lockAdditionalFields().get().isEmpty()) {
                if (generatedMaskFromBidi != null && !generatedMaskFromBidi.isEmpty()) {
                    transformedBody.put("fieldMask", generatedMaskFromBidi);
                } else {
                    transformedBody.remove("fieldMask");
                }
            } else if (configLockExists && config.lockAdditionalFields().isPresent() && !config.lockAdditionalFields().get().isEmpty() && preExistingValid) {
                ImmutableList generationConfigFields = ImmutableList.of((Object)"temperature", (Object)"topK", (Object)"top_k", (Object)"topP", (Object)"top_p", (Object)"maxOutputTokens", (Object)"max_output_tokens", (Object)"responseModalities", (Object)"response_modalities", (Object)"seed", (Object)"speechConfig", (Object)"speech_config", (Object[])new String[0]);
                ArrayList<String> mappedFieldsFromPreExisting = new ArrayList<String>();
                for (String field : preExistingFieldMaskList) {
                    if (generationConfigFields.contains(field)) {
                        mappedFieldsFromPreExisting.add("generationConfig." + field);
                        continue;
                    }
                    mappedFieldsFromPreExisting.add(field);
                }
                ArrayList<String> finalMaskParts = new ArrayList<String>();
                if (generatedMaskFromBidi != null && !generatedMaskFromBidi.isEmpty()) {
                    finalMaskParts.add(generatedMaskFromBidi);
                }
                finalMaskParts.addAll(mappedFieldsFromPreExisting);
                if (!finalMaskParts.isEmpty()) {
                    transformedBody.put("fieldMask", String.join((CharSequence)",", finalMaskParts));
                } else {
                    transformedBody.remove("fieldMask");
                }
            } else {
                transformedBody.remove("fieldMask");
            }
        } else if (preExistingFieldMaskList != null && !preExistingFieldMaskList.isEmpty()) {
            transformedBody.put("fieldMask", String.join((CharSequence)",", preExistingFieldMaskList));
        } else {
            transformedBody.remove("fieldMask");
        }
        return transformedBody;
    }

    Common.BuiltRequest buildRequestForCreate(CreateAuthTokenConfig config) {
        CreateAuthTokenParameters.Builder parameterBuilder = CreateAuthTokenParameters.builder();
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        TokensConverters tokensConverters = new TokensConverters(this.apiClient);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = tokensConverters.createAuthTokenParametersToMldev(this.apiClient, parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("auth_tokens", body.get("_url")) : "auth_tokens";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        ObjectNode transformedBody = this.convertBidiSetupToTokenSetup(body, config);
        transformedBody.remove("config");
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(transformedBody), requestHttpOptions);
    }

    AuthToken processResponseForCreate(ApiResponse response, CreateAuthTokenConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        return JsonSerializable.fromJsonNode(responseNode, AuthToken.class);
    }

    public AuthToken create(CreateAuthTokenConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForCreate(config);
        try (ApiResponse response = this.apiClient.request("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            AuthToken authToken = this.processResponseForCreate(response, config);
            return authToken;
        }
    }
}

