/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.common.collect.ImmutableList;
import com.google.genai.types.HttpRetryOptions;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class RetryInterceptor
implements Interceptor {
    private static final int RETRY_MAX_ATTEMPTS = 5;
    private static final double RETRY_INITIAL_DELAY = 1.0;
    private static final double RETRY_MAX_DELAY = 60.0;
    private static final double RETRY_EXP_BASE = 2.0;
    private static final double RETRY_JITTER = 1.0;
    private static final ImmutableList<Integer> RETRY_HTTP_STATUS_CODES = ImmutableList.of((Object)408, (Object)429, (Object)500, (Object)502, (Object)503, (Object)504);
    private final HttpRetryOptions retryOptions;
    private final Random random;

    RetryInterceptor(HttpRetryOptions retryOptions) {
        this(retryOptions, new Random());
    }

    RetryInterceptor(HttpRetryOptions retryOptions, Random random) {
        this.retryOptions = retryOptions;
        this.random = random;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        HttpRetryOptions options;
        Request request = chain.request();
        HttpRetryOptions perRequestOptions = (HttpRetryOptions)request.tag(HttpRetryOptions.class);
        HttpRetryOptions httpRetryOptions = options = perRequestOptions != null ? perRequestOptions : this.retryOptions;
        if (options == null) {
            return chain.proceed(request);
        }
        Response response = null;
        int maxAttempts = options.attempts().orElse(5);
        maxAttempts = Math.max(maxAttempts, 1);
        List httpStatusCodes = (List)options.httpStatusCodes().orElse((List<Integer>)RETRY_HTTP_STATUS_CODES);
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            block7: {
                try {
                    response = chain.proceed(request);
                    if (response.isSuccessful() || !httpStatusCodes.contains(response.code())) break;
                    if (attempt < maxAttempts) {
                        response.close();
                    }
                }
                catch (IOException e) {
                    if (attempt != maxAttempts) break block7;
                    throw e;
                }
            }
            try {
                Thread.sleep(this.calculateDelay(options, attempt));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Retry was interrupted.", e);
            }
        }
        return response;
    }

    long calculateDelay(HttpRetryOptions options, int attempt) {
        double initialDelay = options.initialDelay().orElse(1.0);
        double maxDelay = options.maxDelay().orElse(60.0);
        double expBase = options.expBase().orElse(2.0);
        double jitter = options.jitter().orElse(1.0);
        double factor = Math.pow(expBase, attempt - 1) * (1.0 + jitter * (this.random.nextDouble() * 2.0 - 1.0));
        double delay = Math.min(maxDelay, initialDelay * factor);
        return (long)(delay * 1000.0);
    }

    HttpRetryOptions retryOptions() {
        return this.retryOptions;
    }
}

