/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiResponse;
import com.google.genai.AsyncChat;
import com.google.genai.Chat;
import com.google.genai.ChatBase;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import okhttp3.Headers;

public class ResponseStream<T extends JsonSerializable>
implements Iterable<T>,
AutoCloseable {
    boolean recordingHistory = false;
    List<T> history = new ArrayList<T>();
    Chat chatSession = null;
    AsyncChat asyncChatSession = null;
    private static final Logger logger = Logger.getLogger(ChatBase.class.getName());
    private final ResponseStreamIterator iterator;
    private final ApiResponse response;
    private final BufferedReader reader;

    public ResponseStream(Class<T> clazz, ApiResponse response, Object obj, String converterName) {
        this(clazz, response, obj, converterName, false, false);
    }

    ResponseStream(Class<T> clazz, ApiResponse response, Object obj, String converterName, boolean needsRootObject, boolean canReturnHttpHeaders) {
        InputStream responseStream = response.getBody().byteStream();
        this.reader = new BufferedReader(new InputStreamReader(responseStream, StandardCharsets.UTF_8));
        Headers headers = null;
        if (canReturnHttpHeaders) {
            headers = response.getHeaders();
        }
        this.iterator = new ResponseStreamIterator(clazz, this.reader, obj, converterName, needsRootObject, headers);
        this.response = response;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public void close() {
        block6: {
            try {
                if (this.reader == null) break block6;
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new GenAiIOException("Failed to close the response stream.", e);
                }
            }
            finally {
                if (this.response != null) {
                    this.response.close();
                }
            }
        }
    }

    boolean isConsumed() {
        return this.iterator.consumed;
    }

    class ResponseStreamIterator
    implements Iterator<T> {
        private final BufferedReader reader;
        private final Class<T> clazz;
        private final Object obj;
        private final Method converter;
        private final boolean needsRootObject;
        private final Headers responseHeaders;
        private String nextJson;
        private boolean consumed = false;

        ResponseStreamIterator(Class<T> clazz, BufferedReader reader, Object obj, String converterName, boolean needsRootObject, Headers responseHeaders) {
            this.reader = reader;
            this.clazz = clazz;
            this.nextJson = this.readNextJson();
            this.obj = obj;
            this.needsRootObject = needsRootObject;
            this.responseHeaders = responseHeaders;
            try {
                this.converter = needsRootObject ? obj.getClass().getDeclaredMethod(converterName, JsonNode.class, ObjectNode.class, JsonNode.class) : obj.getClass().getDeclaredMethod(converterName, JsonNode.class, ObjectNode.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to find converter method " + converterName, e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextJson == null) {
                this.consumed = true;
                if (ResponseStream.this.recordingHistory) {
                    try {
                        if (ResponseStream.this.chatSession != null) {
                            ResponseStream.this.chatSession.checkStreamResponseAndUpdateHistory();
                            ResponseStream.this.recordingHistory = false;
                        }
                        if (ResponseStream.this.asyncChatSession != null) {
                            ResponseStream.this.asyncChatSession.checkStreamResponseAndUpdateHistory();
                            ResponseStream.this.recordingHistory = false;
                        }
                    }
                    catch (IllegalStateException e) {
                        logger.info("Error while updating history: " + e.getMessage() + ". Continuing execution...");
                    }
                }
            }
            return this.nextJson != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more JSON objects in the stream");
            }
            String currentJson = this.nextJson;
            this.nextJson = this.readNextJson();
            try {
                JsonNode currentJsonNode = JsonSerializable.stringToJsonNode(currentJson);
                if (this.responseHeaders != null && currentJsonNode.isObject()) {
                    ObjectNode rootNode = (ObjectNode)currentJsonNode;
                    ObjectNode headersNode = JsonSerializable.objectMapper.createObjectNode();
                    for (String headerName : this.responseHeaders.names()) {
                        headersNode.put(headerName, this.responseHeaders.get(headerName));
                    }
                    ObjectNode sdkHttpResponseNode = JsonSerializable.objectMapper.createObjectNode();
                    sdkHttpResponseNode.set("headers", (JsonNode)headersNode);
                    rootNode.set("sdkHttpResponse", (JsonNode)sdkHttpResponseNode);
                    currentJsonNode = rootNode;
                }
                currentJsonNode = this.needsRootObject ? (JsonNode)this.converter.invoke(this.obj, currentJsonNode, null, currentJsonNode) : (JsonNode)this.converter.invoke(this.obj, currentJsonNode, null);
                Object response = JsonSerializable.fromJsonNode(currentJsonNode, this.clazz);
                if (ResponseStream.this.recordingHistory) {
                    ResponseStream.this.history.add(response);
                }
                return response;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Failed to convert JSON object " + currentJson, e);
            }
        }

        private String readNextJson() {
            try {
                String line = this.reader.readLine();
                if (line == null) {
                    return null;
                }
                if (line.length() == 0) {
                    return this.readNextJson();
                }
                if (line.startsWith("data: ")) {
                    return line.substring("data: ".length());
                }
                return line;
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read next JSON object from the stream", e);
            }
        }
    }
}

