/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Pager;
import com.google.genai.Transformers;
import com.google.genai.UploadClient;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.CreateFileConfig;
import com.google.genai.types.CreateFileParameters;
import com.google.genai.types.CreateFileResponse;
import com.google.genai.types.DeleteFileConfig;
import com.google.genai.types.DeleteFileParameters;
import com.google.genai.types.DeleteFileResponse;
import com.google.genai.types.DownloadFileConfig;
import com.google.genai.types.File;
import com.google.genai.types.GeneratedVideo;
import com.google.genai.types.GetFileConfig;
import com.google.genai.types.GetFileParameters;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.HttpResponse;
import com.google.genai.types.ListFilesConfig;
import com.google.genai.types.ListFilesParameters;
import com.google.genai.types.ListFilesResponse;
import com.google.genai.types.UploadFileConfig;
import com.google.genai.types.Video;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.Headers;
import okhttp3.ResponseBody;

public final class Files {
    final ApiClient apiClient;
    private final UploadClient uploadClient;

    public Files(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.uploadClient = new UploadClient(apiClient);
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createFileParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"file"}) != null) {
            Common.setValueByPath(toObject, new String[]{"file"}, Common.getValueByPath(fromObject, new String[]{"file"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createFileResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteFileParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "file"}, Transformers.tFileName(Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteFileResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getFileParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "file"}, Transformers.tFileName(Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listFilesConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listFilesParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.listFilesConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listFilesResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"files"}) != null) {
            Common.setValueByPath(toObject, new String[]{"files"}, Common.getValueByPath(fromObject, new String[]{"files"}));
        }
        return toObject;
    }

    Common.BuiltRequest buildRequestForPrivateList(ListFilesConfig config) {
        ListFilesParameters.Builder parameterBuilder = ListFilesParameters.builder();
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.listFilesParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("files", body.get("_url")) : "files";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    ListFilesResponse processResponseForPrivateList(ApiResponse response, ListFilesConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.listFilesResponseFromMldev(responseNode, null);
        }
        ListFilesResponse sdkResponse = JsonSerializable.fromJsonNode(responseNode, ListFilesResponse.class);
        Headers responseHeaders = response.getHeaders();
        if (responseHeaders == null) {
            return sdkResponse;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : responseHeaders.names()) {
            headers.put(headerName, responseHeaders.get(headerName));
        }
        return sdkResponse.toBuilder().sdkHttpResponse(HttpResponse.builder().headers(headers)).build();
    }

    ListFilesResponse privateList(ListFilesConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateList(config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            ListFilesResponse listFilesResponse = this.processResponseForPrivateList(response, config);
            return listFilesResponse;
        }
    }

    Common.BuiltRequest buildRequestForPrivateCreate(File file, CreateFileConfig config) {
        CreateFileParameters.Builder parameterBuilder = CreateFileParameters.builder();
        if (!Common.isZero(file)) {
            parameterBuilder.file(file);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.createFileParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("upload/v1beta/files", body.get("_url")) : "upload/v1beta/files";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    CreateFileResponse processResponseForPrivateCreate(ApiResponse response, CreateFileConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        if (config != null && config.shouldReturnHttpResponse().orElse(false).booleanValue()) {
            Headers responseHeaders = response.getHeaders();
            if (responseHeaders == null) {
                return CreateFileResponse.builder().sdkHttpResponse(HttpResponse.builder().body(responseString)).build();
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            for (String headerName : responseHeaders.names()) {
                headers.put(headerName, responseHeaders.get(headerName));
            }
            return CreateFileResponse.builder().sdkHttpResponse(HttpResponse.builder().headers(headers).body(responseString)).build();
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.createFileResponseFromMldev(responseNode, null);
        }
        return JsonSerializable.fromJsonNode(responseNode, CreateFileResponse.class);
    }

    CreateFileResponse privateCreate(File file, CreateFileConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateCreate(file, config);
        try (ApiResponse response = this.apiClient.request("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            CreateFileResponse createFileResponse = this.processResponseForPrivateCreate(response, config);
            return createFileResponse;
        }
    }

    Common.BuiltRequest buildRequestForGet(String name, GetFileConfig config) {
        GetFileParameters.Builder parameterBuilder = GetFileParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.getFileParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("files/{file}", body.get("_url")) : "files/{file}";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    File processResponseForGet(ApiResponse response, GetFileConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        return JsonSerializable.fromJsonNode(responseNode, File.class);
    }

    public File get(String name, GetFileConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForGet(name, config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            File file = this.processResponseForGet(response, config);
            return file;
        }
    }

    Common.BuiltRequest buildRequestForDelete(String name, DeleteFileConfig config) {
        DeleteFileParameters.Builder parameterBuilder = DeleteFileParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.deleteFileParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("files/{file}", body.get("_url")) : "files/{file}";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    DeleteFileResponse processResponseForDelete(ApiResponse response, DeleteFileConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.deleteFileResponseFromMldev(responseNode, null);
        }
        DeleteFileResponse sdkResponse = JsonSerializable.fromJsonNode(responseNode, DeleteFileResponse.class);
        Headers responseHeaders = response.getHeaders();
        if (responseHeaders == null) {
            return sdkResponse;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : responseHeaders.names()) {
            headers.put(headerName, responseHeaders.get(headerName));
        }
        return sdkResponse.toBuilder().sdkHttpResponse(HttpResponse.builder().headers(headers)).build();
    }

    public DeleteFileResponse delete(String name, DeleteFileConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForDelete(name, config);
        try (ApiResponse response = this.apiClient.request("delete", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            DeleteFileResponse deleteFileResponse = this.processResponseForDelete(response, config);
            return deleteFileResponse;
        }
    }

    public Pager<File> list(ListFilesConfig config) {
        if (config == null) {
            config = ListFilesConfig.builder().build();
        }
        Function<JsonSerializable, Object> request = requestConfig -> {
            if (!(requestConfig instanceof ListFilesConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListFilesConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListFilesConfig)requestConfig);
        };
        return new Pager<File>(BasePager.PagedItem.FILES, request, (ObjectNode)JsonSerializable.toJsonNode(config), JsonSerializable.toJsonNode(this.privateList(config)));
    }

    public File upload(java.io.File file, UploadFileConfig config) {
        File file2;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            long size = file.length();
            String fileName = file.getName();
            String probedMimeType = java.nio.file.Files.probeContentType(file.toPath());
            Optional<String> mimeType = probedMimeType != null ? Optional.of(probedMimeType) : Optional.empty();
            String uploadUrl = this.createFileInApi(config, mimeType, Optional.of(fileName), size);
            ResponseBody responseBody = this.uploadClient.upload(uploadUrl, inputStream, size);
            file2 = this.fileFromUploadResponseBody(responseBody);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to upload file.", e);
            }
        }
        ((InputStream)inputStream).close();
        return file2;
    }

    public File upload(byte[] bytes, UploadFileConfig config) {
        String uploadUrl = this.createFileInApi(config, Optional.empty(), Optional.empty(), bytes.length);
        ResponseBody responseBody = this.uploadClient.upload(uploadUrl, bytes);
        return this.fileFromUploadResponseBody(responseBody);
    }

    public File upload(InputStream inputStream, long size, UploadFileConfig config) {
        String uploadUrl = this.createFileInApi(config, Optional.empty(), Optional.empty(), size);
        ResponseBody responseBody = this.uploadClient.upload(uploadUrl, inputStream, size);
        return this.fileFromUploadResponseBody(responseBody);
    }

    public File upload(String filePath, UploadFileConfig config) {
        java.io.File file = new java.io.File(filePath);
        return this.upload(file, config);
    }

    private File fileFromUploadResponseBody(ResponseBody responseBody) {
        String responseString;
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        responseNode = responseNode.get("file");
        return JsonSerializable.fromJsonNode(responseNode, File.class);
    }

    private String createFileInApi(UploadFileConfig config, Optional<String> mimeType, Optional<String> fileName, long size) {
        File apiFile;
        File.Builder apiFileBuilder = File.builder();
        Optional<HttpOptions> userHttpOptions = Optional.empty();
        if (config != null) {
            userHttpOptions = config.httpOptions();
            if (config.name().isPresent()) {
                apiFileBuilder.name(config.name().get());
            }
            if (config.mimeType().isPresent()) {
                apiFileBuilder.mimeType(config.mimeType().get());
            }
            if (config.displayName().isPresent()) {
                apiFileBuilder.displayName(config.displayName().get());
            }
        }
        if ((apiFile = apiFileBuilder.build()).name().isPresent() && !apiFile.name().get().startsWith("files/")) {
            apiFile = apiFile.toBuilder().name("files/" + apiFile.name().get()).build();
        }
        Optional<String> mimeTypeToUse = mimeType.isPresent() ? mimeType : (apiFile.mimeType().isPresent() ? apiFile.mimeType() : Optional.empty());
        HttpOptions createFileHttpOptions = UploadClient.buildResumableUploadHttpOptions(userHttpOptions, mimeTypeToUse, fileName, size);
        CreateFileResponse createFileResponse = this.privateCreate(apiFile, CreateFileConfig.builder().httpOptions(createFileHttpOptions).shouldReturnHttpResponse(true).build());
        return (String)createFileResponse.sdkHttpResponse().flatMap(HttpResponse::headers).flatMap(headers -> headers.entrySet().stream().filter(entry -> Ascii.equalsIgnoreCase((CharSequence)"x-goog-upload-url", (CharSequence)((CharSequence)entry.getKey()))).map(entry -> (String)entry.getValue()).findFirst()).orElseThrow(() -> new IllegalStateException("Failed to create file. Upload URL was not returned in the create file response."));
    }

    public void download(String fileName, String downloadPath, DownloadFileConfig config) {
        Preconditions.checkNotNull((Object)fileName);
        Preconditions.checkNotNull((Object)downloadPath);
        String extractedFileName = Transformers.tFileName(fileName);
        this.downloadTo(extractedFileName, downloadPath, config);
    }

    public void download(Video video, String downloadPath, DownloadFileConfig config) {
        Preconditions.checkNotNull((Object)video);
        Preconditions.checkNotNull((Object)downloadPath);
        String extractedFileName = Transformers.tFileName(video);
        if (extractedFileName != null) {
            this.downloadTo(extractedFileName, downloadPath, config);
        } else {
            this.saveTo(video.videoBytes().orElseThrow(() -> new IllegalArgumentException("Video bytes are required.")), downloadPath);
        }
    }

    public void download(File file, String downloadPath, DownloadFileConfig config) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)downloadPath);
        String extractedFileName = Transformers.tFileName(file);
        this.downloadTo(extractedFileName, downloadPath, config);
    }

    public void download(GeneratedVideo generatedVideo, String downloadPath, DownloadFileConfig config) {
        Preconditions.checkNotNull((Object)generatedVideo);
        Preconditions.checkNotNull((Object)downloadPath);
        String extractedFileName = Transformers.tFileName(generatedVideo);
        if (extractedFileName != null) {
            this.downloadTo(extractedFileName, downloadPath, config);
        } else {
            this.saveTo(generatedVideo.video().orElseThrow(() -> new IllegalArgumentException("Video is required.")).videoBytes().orElseThrow(() -> new IllegalArgumentException("Video bytes are required.")), downloadPath);
        }
    }

    private void downloadTo(String fileName, String downloadPath, DownloadFileConfig config) {
        Optional<HttpOptions> httpOptions = Optional.empty();
        if (config != null) {
            httpOptions = config.httpOptions();
        }
        ApiResponse response = this.apiClient.request("get", String.format("files/%s:download?alt=media", fileName), "", httpOptions);
        try (FileOutputStream outputStream = new FileOutputStream(downloadPath);){
            outputStream.write(response.getBody().bytes());
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to download file.", e);
        }
    }

    private void saveTo(byte[] bytes, String downloadPath) {
        try (FileOutputStream outputStream = new FileOutputStream(downloadPath);){
            outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to save file.", e);
        }
    }
}

