/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.AfcUtil;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.JsonSerializable;
import com.google.genai.Models;
import com.google.genai.ResponseStream;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.ComputeTokensConfig;
import com.google.genai.types.ComputeTokensResponse;
import com.google.genai.types.Content;
import com.google.genai.types.CountTokensConfig;
import com.google.genai.types.CountTokensResponse;
import com.google.genai.types.DeleteModelConfig;
import com.google.genai.types.DeleteModelResponse;
import com.google.genai.types.EditImageConfig;
import com.google.genai.types.EditImageResponse;
import com.google.genai.types.EmbedContentConfig;
import com.google.genai.types.EmbedContentResponse;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.GenerateImagesConfig;
import com.google.genai.types.GenerateImagesResponse;
import com.google.genai.types.GenerateVideosConfig;
import com.google.genai.types.GenerateVideosOperation;
import com.google.genai.types.GenerateVideosSource;
import com.google.genai.types.GetModelConfig;
import com.google.genai.types.Image;
import com.google.genai.types.ListModelsConfig;
import com.google.genai.types.ListModelsResponse;
import com.google.genai.types.Model;
import com.google.genai.types.Part;
import com.google.genai.types.RecontextImageConfig;
import com.google.genai.types.RecontextImageResponse;
import com.google.genai.types.RecontextImageSource;
import com.google.genai.types.ReferenceImage;
import com.google.genai.types.ReferenceImageAPI;
import com.google.genai.types.SegmentImageConfig;
import com.google.genai.types.SegmentImageResponse;
import com.google.genai.types.SegmentImageSource;
import com.google.genai.types.UpdateModelConfig;
import com.google.genai.types.UpscaleImageAPIConfig;
import com.google.genai.types.UpscaleImageConfig;
import com.google.genai.types.UpscaleImageResponse;
import com.google.genai.types.Video;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Logger;

public final class AsyncModels {
    Models models;
    ApiClient apiClient;
    private static final Logger logger = Logger.getLogger(AsyncModels.class.getName());

    public AsyncModels(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.models = new Models(apiClient);
    }

    CompletableFuture<GenerateContentResponse> privateGenerateContent(String model, List<Content> contents, GenerateContentConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForPrivateGenerateContent(model, contents, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                GenerateContentResponse generateContentResponse = this.models.processResponseForPrivateGenerateContent(res, config);
                return generateContentResponse;
            }
        });
    }

    CompletableFuture<ResponseStream<GenerateContentResponse>> privateGenerateContentStream(String model, List<Content> contents, GenerateContentConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForPrivateGenerateContentStream(model, contents, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> this.models.processResponseForPrivateGenerateContentStream((ApiResponse)response, config));
    }

    CompletableFuture<EmbedContentResponse> privateEmbedContent(String model, List<Content> contents, EmbedContentConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForPrivateEmbedContent(model, contents, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                EmbedContentResponse embedContentResponse = this.models.processResponseForPrivateEmbedContent(res, config);
                return embedContentResponse;
            }
        });
    }

    CompletableFuture<GenerateImagesResponse> privateGenerateImages(String model, String prompt, GenerateImagesConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForPrivateGenerateImages(model, prompt, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                GenerateImagesResponse generateImagesResponse = this.models.processResponseForPrivateGenerateImages(res, config);
                return generateImagesResponse;
            }
        });
    }

    CompletableFuture<EditImageResponse> privateEditImage(String model, String prompt, List<ReferenceImageAPI> referenceImages, EditImageConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForPrivateEditImage(model, prompt, referenceImages, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                EditImageResponse editImageResponse = this.models.processResponseForPrivateEditImage(res, config);
                return editImageResponse;
            }
        });
    }

    CompletableFuture<UpscaleImageResponse> privateUpscaleImage(String model, Image image, String upscaleFactor, UpscaleImageAPIConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForPrivateUpscaleImage(model, image, upscaleFactor, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                UpscaleImageResponse upscaleImageResponse = this.models.processResponseForPrivateUpscaleImage(res, config);
                return upscaleImageResponse;
            }
        });
    }

    public CompletableFuture<RecontextImageResponse> recontextImage(String model, RecontextImageSource source, RecontextImageConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForRecontextImage(model, source, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                RecontextImageResponse recontextImageResponse = this.models.processResponseForRecontextImage(res, config);
                return recontextImageResponse;
            }
        });
    }

    public CompletableFuture<SegmentImageResponse> segmentImage(String model, SegmentImageSource source, SegmentImageConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForSegmentImage(model, source, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                SegmentImageResponse segmentImageResponse = this.models.processResponseForSegmentImage(res, config);
                return segmentImageResponse;
            }
        });
    }

    public CompletableFuture<Model> get(String model, GetModelConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForGet(model, config);
        return this.apiClient.asyncRequest("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                Model model = this.models.processResponseForGet(res, config);
                return model;
            }
        });
    }

    CompletableFuture<ListModelsResponse> privateList(ListModelsConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForPrivateList(config);
        return this.apiClient.asyncRequest("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                ListModelsResponse listModelsResponse = this.models.processResponseForPrivateList(res, config);
                return listModelsResponse;
            }
        });
    }

    public CompletableFuture<Model> update(String model, UpdateModelConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForUpdate(model, config);
        return this.apiClient.asyncRequest("patch", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                Model model = this.models.processResponseForUpdate(res, config);
                return model;
            }
        });
    }

    public CompletableFuture<DeleteModelResponse> delete(String model, DeleteModelConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForDelete(model, config);
        return this.apiClient.asyncRequest("delete", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                DeleteModelResponse deleteModelResponse = this.models.processResponseForDelete(res, config);
                return deleteModelResponse;
            }
        });
    }

    public CompletableFuture<CountTokensResponse> countTokens(String model, List<Content> contents, CountTokensConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForCountTokens(model, contents, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                CountTokensResponse countTokensResponse = this.models.processResponseForCountTokens(res, config);
                return countTokensResponse;
            }
        });
    }

    public CompletableFuture<ComputeTokensResponse> computeTokens(String model, List<Content> contents, ComputeTokensConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForComputeTokens(model, contents, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                ComputeTokensResponse computeTokensResponse = this.models.processResponseForComputeTokens(res, config);
                return computeTokensResponse;
            }
        });
    }

    CompletableFuture<GenerateVideosOperation> privateGenerateVideos(String model, String prompt, Image image, Video video, GenerateVideosSource source, GenerateVideosConfig config) {
        Common.BuiltRequest builtRequest = this.models.buildRequestForPrivateGenerateVideos(model, prompt, image, video, source, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                GenerateVideosOperation generateVideosOperation = this.models.processResponseForPrivateGenerateVideos(res, config);
                return generateVideosOperation;
            }
        });
    }

    public CompletableFuture<CountTokensResponse> countTokens(String model, String text, CountTokensConfig config) {
        return this.countTokens(model, (List<Content>)Transformers.tContents(text), config);
    }

    public CompletableFuture<ComputeTokensResponse> computeTokens(String model, String text, ComputeTokensConfig config) {
        return this.computeTokens(model, (List<Content>)Transformers.tContents(text), config);
    }

    private CompletableFuture<AfcLoopResult> privateGenerateContentLoopAsync(String model, List<Content> contents, GenerateContentConfig transformedConfig, ImmutableMap<String, Method> functionMap, List<Content> automaticFunctionCallingHistory, int remainingRemoteCalls, int initialMaxCalls) {
        logger.info(String.format("Automatic function calling remote call %d is done", initialMaxCalls - remainingRemoteCalls + 1));
        return this.privateGenerateContent(model, contents, transformedConfig).thenCompose(response -> {
            if (remainingRemoteCalls - 1 <= 0) {
                logger.info("Reached max remote calls for automatic function calling.");
                return CompletableFuture.completedFuture(new AfcLoopResult((GenerateContentResponse)response, automaticFunctionCallingHistory));
            }
            if (!response.candidates().isPresent() || response.candidates().get().isEmpty() || !response.candidates().get().get(0).content().isPresent() || !response.candidates().get().get(0).content().get().parts().isPresent() || response.candidates().get().get(0).content().get().parts().get().isEmpty()) {
                return CompletableFuture.completedFuture(new AfcLoopResult((GenerateContentResponse)response, automaticFunctionCallingHistory));
            }
            ImmutableList<Part> functionResponseParts = AfcUtil.getFunctionResponseParts(response, functionMap);
            if (functionResponseParts.isEmpty()) {
                return CompletableFuture.completedFuture(new AfcLoopResult((GenerateContentResponse)response, automaticFunctionCallingHistory));
            }
            Content functionCallContent = response.candidates().get().get(0).content().get();
            Content functionResponseContent = Content.builder().role("user").parts((List<Part>)functionResponseParts).build();
            ArrayList<Content> newHistory = new ArrayList<Content>(automaticFunctionCallingHistory);
            newHistory.add(functionCallContent);
            newHistory.add(functionResponseContent);
            return this.privateGenerateContentLoopAsync(model, newHistory, transformedConfig, functionMap, newHistory, remainingRemoteCalls - 1, initialMaxCalls);
        });
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, List<Content> contents, GenerateContentConfig config) {
        ImmutableList<Integer> incompatibleToolsIndexes = AfcUtil.findAfcIncompatibleToolIndexes(config);
        GenerateContentConfig transformedConfig = AfcUtil.transformGenerateContentConfig(config);
        if (AfcUtil.shouldDisableAfc(transformedConfig)) {
            return this.privateGenerateContent(model, contents, transformedConfig);
        }
        if (!incompatibleToolsIndexes.isEmpty()) {
            int originalToolsSize = 0;
            if (config.tools().isPresent() && !config.tools().get().isEmpty()) {
                originalToolsSize = config.tools().get().size();
            }
            if (originalToolsSize != incompatibleToolsIndexes.size()) {
                logger.warning(String.format("Automatic function calling is enabled, but the following tools are not supported: %s. AFC will be disabled.", incompatibleToolsIndexes));
            }
            return this.privateGenerateContent(model, contents, transformedConfig);
        }
        ImmutableMap<String, Method> functionMap = AfcUtil.getFunctionMap(config);
        if (functionMap.isEmpty()) {
            return this.privateGenerateContent(model, contents, transformedConfig);
        }
        int maxRemoteCalls = AfcUtil.getMaxRemoteCallsAfc(transformedConfig);
        logger.info(String.format("Automatic function calling is enabled with max remote calls: %d", maxRemoteCalls));
        ArrayList<Content> automaticFunctionCallingHistory = new ArrayList<Content>(contents);
        return this.privateGenerateContentLoopAsync(model, contents, transformedConfig, functionMap, automaticFunctionCallingHistory, maxRemoteCalls, maxRemoteCalls).thenApply(loopResult -> {
            if (AfcUtil.shouldAppendAfcHistory(transformedConfig)) {
                ObjectNode responseNode = (ObjectNode)JsonSerializable.objectMapper.valueToTree((Object)loopResult.response);
                responseNode.set("automaticFunctionCallingHistory", JsonSerializable.objectMapper.valueToTree(loopResult.history));
                return JsonSerializable.fromJsonNode((JsonNode)responseNode, GenerateContentResponse.class);
            }
            return loopResult.response;
        });
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, Content content, GenerateContentConfig config) {
        return this.generateContent(model, (List<Content>)Transformers.tContents(content), config);
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, String text, GenerateContentConfig config) {
        return this.generateContent(model, (List<Content>)Transformers.tContents(text), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, List<Content> contents, GenerateContentConfig config) {
        GenerateContentConfig transformedConfig = AfcUtil.transformGenerateContentConfig(config);
        if (AfcUtil.hasCallableTool(config) && !AfcUtil.shouldDisableAfc(transformedConfig)) {
            logger.warning("In generateContentStream method, detected that automatic function calling is enabled in the config.AutomaticFunctionCalling(), and callable tool is present in the config.tools() list. Automatic function calling is not supported in streaming methods at the moment, will just return the function call parts from model if there is any.");
        }
        return this.privateGenerateContentStream(model, contents, transformedConfig);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, Content content, GenerateContentConfig config) {
        return this.generateContentStream(model, (List<Content>)Transformers.tContents(content), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, String text, GenerateContentConfig config) {
        return this.generateContentStream(model, (List<Content>)Transformers.tContents(text), config);
    }

    public CompletableFuture<GenerateImagesResponse> generateImages(String model, String prompt, GenerateImagesConfig config) {
        return this.privateGenerateImages(model, prompt, config).thenApply(this.models::postProcessGenerateImagesResponse);
    }

    public CompletableFuture<EditImageResponse> editImage(String model, String prompt, List<ReferenceImage> referenceImages, EditImageConfig config) {
        ArrayList<ReferenceImageAPI> referenceImagesAPI = new ArrayList<ReferenceImageAPI>();
        for (ReferenceImage referenceImage : referenceImages) {
            referenceImagesAPI.add(referenceImage.toReferenceImageAPI());
        }
        return this.privateEditImage(model, prompt, referenceImagesAPI, config);
    }

    public CompletableFuture<UpscaleImageResponse> upscaleImage(String model, Image image, String upscaleFactor, UpscaleImageConfig config) {
        return this.privateUpscaleImage(model, image, upscaleFactor, this.models.preProcessUpscaleImageConfig(config));
    }

    public CompletableFuture<GenerateVideosOperation> generateVideos(String model, GenerateVideosSource source, GenerateVideosConfig config) {
        return this.privateGenerateVideos(model, null, null, null, this.models.preProcessGenerateVideosSource(source), config);
    }

    public CompletableFuture<GenerateVideosOperation> generateVideos(String model, String prompt, Image image, Video video, GenerateVideosConfig config) {
        return this.privateGenerateVideos(model, prompt, image, this.models.preProcessVideo(video), null, config);
    }

    public CompletableFuture<GenerateVideosOperation> generateVideos(String model, String prompt, Image image, GenerateVideosConfig config) {
        return this.generateVideos(model, prompt, image, null, config);
    }

    public CompletableFuture<EmbedContentResponse> embedContent(String model, String text, EmbedContentConfig config) {
        return this.embedContent(model, (List<String>)ImmutableList.of((Object)text), config);
    }

    public CompletableFuture<EmbedContentResponse> embedContent(String model, List<String> texts, EmbedContentConfig config) {
        ArrayList<Content> contents = new ArrayList<Content>();
        for (String text : texts) {
            contents.add(Content.fromParts(Part.fromText(text)));
        }
        return this.privateEmbedContent(model, contents, config);
    }

    public CompletableFuture<AsyncPager<Model>> list(ListModelsConfig config) {
        if (config == null) {
            config = ListModelsConfig.builder().build();
        }
        if (config.filter().isPresent()) {
            throw new IllegalArgumentException("Filter is currently not supported for list models.");
        }
        ListModelsConfig.Builder configBuilder = config.toBuilder();
        if (!config.queryBase().isPresent()) {
            configBuilder.queryBase(true);
        } else if (!config.queryBase().get().booleanValue() && this.models.apiClient.vertexAI()) {
            configBuilder.filter("labels.tune-type:*");
        }
        ListModelsConfig updatedConfig = configBuilder.build();
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListModelsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListModelsConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListModelsConfig)requestConfig).thenApply(JsonSerializable::toJsonNode);
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.MODELS, request, (ObjectNode)JsonSerializable.toJsonNode(updatedConfig), (CompletableFuture)request.apply(updatedConfig)));
    }

    private static class AfcLoopResult {
        final GenerateContentResponse response;
        final List<Content> history;

        AfcLoopResult(GenerateContentResponse response, List<Content> history) {
            this.response = response;
            this.history = history;
        }
    }
}

