/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.Files;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.CreateFileConfig;
import com.google.genai.types.CreateFileResponse;
import com.google.genai.types.DeleteFileConfig;
import com.google.genai.types.DeleteFileResponse;
import com.google.genai.types.DownloadFileConfig;
import com.google.genai.types.File;
import com.google.genai.types.GeneratedVideo;
import com.google.genai.types.GetFileConfig;
import com.google.genai.types.ListFilesConfig;
import com.google.genai.types.ListFilesResponse;
import com.google.genai.types.UploadFileConfig;
import com.google.genai.types.Video;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncFiles {
    Files files;
    ApiClient apiClient;

    public AsyncFiles(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.files = new Files(apiClient);
    }

    CompletableFuture<ListFilesResponse> privateList(ListFilesConfig config) {
        Common.BuiltRequest builtRequest = this.files.buildRequestForPrivateList(config);
        return this.apiClient.asyncRequest("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                ListFilesResponse listFilesResponse = this.files.processResponseForPrivateList(res, config);
                return listFilesResponse;
            }
        });
    }

    CompletableFuture<CreateFileResponse> privateCreate(File file, CreateFileConfig config) {
        Common.BuiltRequest builtRequest = this.files.buildRequestForPrivateCreate(file, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                CreateFileResponse createFileResponse = this.files.processResponseForPrivateCreate(res, config);
                return createFileResponse;
            }
        });
    }

    public CompletableFuture<File> get(String name, GetFileConfig config) {
        Common.BuiltRequest builtRequest = this.files.buildRequestForGet(name, config);
        return this.apiClient.asyncRequest("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                File file = this.files.processResponseForGet(res, config);
                return file;
            }
        });
    }

    public CompletableFuture<DeleteFileResponse> delete(String name, DeleteFileConfig config) {
        Common.BuiltRequest builtRequest = this.files.buildRequestForDelete(name, config);
        return this.apiClient.asyncRequest("delete", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                DeleteFileResponse deleteFileResponse = this.files.processResponseForDelete(res, config);
                return deleteFileResponse;
            }
        });
    }

    public CompletableFuture<AsyncPager<File>> list(ListFilesConfig config) {
        if (config == null) {
            config = ListFilesConfig.builder().build();
        }
        ListFilesConfig finalConfig = config;
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListFilesConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListFilesConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListFilesConfig)requestConfig).thenApply(JsonSerializable::toJsonNode);
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.FILES, request, (ObjectNode)JsonSerializable.toJsonNode(finalConfig), (CompletableFuture)request.apply(finalConfig)));
    }

    public CompletableFuture<File> upload(java.io.File file, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(file, config));
    }

    public CompletableFuture<File> upload(byte[] bytes, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(bytes, config));
    }

    public CompletableFuture<File> upload(InputStream stream, long size, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(stream, size, config));
    }

    public CompletableFuture<File> upload(String filePath, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(filePath, config));
    }

    public CompletableFuture<Void> download(String fileName, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(fileName, downloadPath, config));
    }

    public CompletableFuture<Void> download(Video video, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(video, downloadPath, config));
    }

    public CompletableFuture<Void> download(GeneratedVideo video, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(video, downloadPath, config));
    }

    public CompletableFuture<Void> download(File file, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(file, downloadPath, config));
    }
}

