/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Ascii;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.AsyncDocuments;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.FileSearchStores;
import com.google.genai.JsonSerializable;
import com.google.genai.UploadClient;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.CreateFileSearchStoreConfig;
import com.google.genai.types.DeleteFileSearchStoreConfig;
import com.google.genai.types.FileSearchStore;
import com.google.genai.types.GetFileSearchStoreConfig;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.HttpResponse;
import com.google.genai.types.ImportFileConfig;
import com.google.genai.types.ImportFileOperation;
import com.google.genai.types.ListFileSearchStoresConfig;
import com.google.genai.types.ListFileSearchStoresResponse;
import com.google.genai.types.UploadToFileSearchStoreConfig;
import com.google.genai.types.UploadToFileSearchStoreOperation;
import com.google.genai.types.UploadToFileSearchStoreResumableResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import okhttp3.ResponseBody;

public final class AsyncFileSearchStores {
    public final AsyncDocuments documents;
    FileSearchStores fileSearchStores;
    ApiClient apiClient;
    private final UploadClient uploadClient;

    public AsyncFileSearchStores(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.fileSearchStores = new FileSearchStores(apiClient);
        this.uploadClient = new UploadClient(apiClient);
        this.documents = new AsyncDocuments(apiClient);
    }

    public CompletableFuture<FileSearchStore> create(CreateFileSearchStoreConfig config) {
        Common.BuiltRequest builtRequest = this.fileSearchStores.buildRequestForCreate(config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                FileSearchStore fileSearchStore = this.fileSearchStores.processResponseForCreate(res, config);
                return fileSearchStore;
            }
        });
    }

    public CompletableFuture<FileSearchStore> get(String name, GetFileSearchStoreConfig config) {
        Common.BuiltRequest builtRequest = this.fileSearchStores.buildRequestForGet(name, config);
        return this.apiClient.asyncRequest("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                FileSearchStore fileSearchStore = this.fileSearchStores.processResponseForGet(res, config);
                return fileSearchStore;
            }
        });
    }

    public CompletableFuture<Void> delete(String name, DeleteFileSearchStoreConfig config) {
        Common.BuiltRequest builtRequest = this.fileSearchStores.buildRequestForDelete(name, config);
        return this.apiClient.asyncRequest("delete", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenAccept(response -> {
            ApiResponse res = response;
            if (res != null) {
                res.close();
            }
        });
    }

    CompletableFuture<ListFileSearchStoresResponse> privateList(ListFileSearchStoresConfig config) {
        Common.BuiltRequest builtRequest = this.fileSearchStores.buildRequestForPrivateList(config);
        return this.apiClient.asyncRequest("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                ListFileSearchStoresResponse listFileSearchStoresResponse = this.fileSearchStores.processResponseForPrivateList(res, config);
                return listFileSearchStoresResponse;
            }
        });
    }

    CompletableFuture<UploadToFileSearchStoreResumableResponse> privateUploadToFileSearchStore(String fileSearchStoreName, UploadToFileSearchStoreConfig config) {
        Common.BuiltRequest builtRequest = this.fileSearchStores.buildRequestForPrivateUploadToFileSearchStore(fileSearchStoreName, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                UploadToFileSearchStoreResumableResponse uploadToFileSearchStoreResumableResponse = this.fileSearchStores.processResponseForPrivateUploadToFileSearchStore(res, config);
                return uploadToFileSearchStoreResumableResponse;
            }
        });
    }

    public CompletableFuture<ImportFileOperation> importFile(String fileSearchStoreName, String fileName, ImportFileConfig config) {
        Common.BuiltRequest builtRequest = this.fileSearchStores.buildRequestForImportFile(fileSearchStoreName, fileName, config);
        return this.apiClient.asyncRequest("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                ImportFileOperation importFileOperation = this.fileSearchStores.processResponseForImportFile(res, config);
                return importFileOperation;
            }
        });
    }

    public CompletableFuture<AsyncPager<FileSearchStore>> list(ListFileSearchStoresConfig config) {
        if (config == null) {
            config = ListFileSearchStoresConfig.builder().build();
        }
        ListFileSearchStoresConfig finalConfig = config;
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListFileSearchStoresConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListFileSearchStoresConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListFileSearchStoresConfig)requestConfig).thenApply(JsonSerializable::toJsonNode);
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.FILE_SEARCH_STORES, request, (ObjectNode)JsonSerializable.toJsonNode(finalConfig), (CompletableFuture)request.apply(finalConfig)));
    }

    private CompletableFuture<String> getUploadUrl(String fileSearchStoreName, UploadToFileSearchStoreConfig config, Optional<String> mimeType, Optional<String> fileName, long size) {
        Optional<String> mimeTypeToUse = mimeType.isPresent() ? mimeType : Optional.ofNullable(config).flatMap(UploadToFileSearchStoreConfig::mimeType);
        Optional<HttpOptions> userHttpOptions = Optional.ofNullable(config).flatMap(UploadToFileSearchStoreConfig::httpOptions);
        HttpOptions httpOptions = UploadClient.buildResumableUploadHttpOptions(userHttpOptions, mimeTypeToUse, fileName, size);
        return this.privateUploadToFileSearchStore(fileSearchStoreName, UploadToFileSearchStoreConfig.builder().httpOptions(httpOptions).shouldReturnHttpResponse(true).build()).thenApply(response -> (String)response.sdkHttpResponse().flatMap(HttpResponse::headers).flatMap(headers -> headers.entrySet().stream().filter(entry -> Ascii.equalsIgnoreCase((CharSequence)"x-goog-upload-url", (CharSequence)((CharSequence)entry.getKey()))).map(entry -> (String)entry.getValue()).findFirst()).orElseThrow(() -> new IllegalStateException("Failed to upload to file search store. Upload URL was not returned in the resumable response.")));
    }

    public CompletableFuture<UploadToFileSearchStoreOperation> uploadToFileSearchStore(String fileSearchStoreName, File file, UploadToFileSearchStoreConfig config) {
        Optional<String> mimeType;
        long size = file.length();
        String fileName = file.getName();
        try {
            String probedMimeType = Files.probeContentType(file.toPath());
            mimeType = Optional.ofNullable(probedMimeType);
        }
        catch (IOException e) {
            mimeType = Optional.empty();
        }
        return ((CompletableFuture)this.getUploadUrl(fileSearchStoreName, config, mimeType, Optional.of(fileName), size).thenCompose(uploadUrl -> CompletableFuture.supplyAsync(() -> {
            ResponseBody responseBody;
            FileInputStream inputStream = new FileInputStream(file);
            try {
                responseBody = this.uploadClient.upload((String)uploadUrl, inputStream, size);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GenAiIOException("Failed to upload file.", e);
                }
            }
            ((InputStream)inputStream).close();
            return responseBody;
        }))).thenApply(FileSearchStores::operationFromResponse);
    }

    public CompletableFuture<UploadToFileSearchStoreOperation> uploadToFileSearchStore(String fileSearchStoreName, byte[] bytes, UploadToFileSearchStoreConfig config) {
        return ((CompletableFuture)this.getUploadUrl(fileSearchStoreName, config, Optional.empty(), Optional.empty(), bytes.length).thenCompose(uploadUrl -> CompletableFuture.supplyAsync(() -> this.uploadClient.upload((String)uploadUrl, bytes)))).thenApply(FileSearchStores::operationFromResponse);
    }

    public CompletableFuture<UploadToFileSearchStoreOperation> uploadToFileSearchStore(String fileSearchStoreName, InputStream inputStream, long size, UploadToFileSearchStoreConfig config) {
        return ((CompletableFuture)this.getUploadUrl(fileSearchStoreName, config, Optional.empty(), Optional.empty(), size).thenCompose(uploadUrl -> CompletableFuture.supplyAsync(() -> this.uploadClient.upload((String)uploadUrl, inputStream, size)))).thenApply(FileSearchStores::operationFromResponse);
    }

    public CompletableFuture<UploadToFileSearchStoreOperation> uploadToFileSearchStore(String fileSearchStoreName, String filePath, UploadToFileSearchStoreConfig config) {
        File file = new File(filePath);
        return this.uploadToFileSearchStore(fileSearchStoreName, file, config);
    }
}

