/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.Documents;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.DeleteDocumentConfig;
import com.google.genai.types.Document;
import com.google.genai.types.GetDocumentConfig;
import com.google.genai.types.ListDocumentsConfig;
import com.google.genai.types.ListDocumentsResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncDocuments {
    Documents documents;
    ApiClient apiClient;

    public AsyncDocuments(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.documents = new Documents(apiClient);
    }

    public CompletableFuture<Document> get(String name, GetDocumentConfig config) {
        Common.BuiltRequest builtRequest = this.documents.buildRequestForGet(name, config);
        return this.apiClient.asyncRequest("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                Document document = this.documents.processResponseForGet(res, config);
                return document;
            }
        });
    }

    public CompletableFuture<Void> delete(String name, DeleteDocumentConfig config) {
        Common.BuiltRequest builtRequest = this.documents.buildRequestForDelete(name, config);
        return this.apiClient.asyncRequest("delete", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenAccept(response -> {
            ApiResponse res = response;
            if (res != null) {
                res.close();
            }
        });
    }

    CompletableFuture<ListDocumentsResponse> privateList(String parent, ListDocumentsConfig config) {
        Common.BuiltRequest builtRequest = this.documents.buildRequestForPrivateList(parent, config);
        return this.apiClient.asyncRequest("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions()).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                ListDocumentsResponse listDocumentsResponse = this.documents.processResponseForPrivateList(res, config);
                return listDocumentsResponse;
            }
        });
    }

    public CompletableFuture<AsyncPager<Document>> list(String parent, ListDocumentsConfig config) {
        if (config == null) {
            config = ListDocumentsConfig.builder().build();
        }
        ListDocumentsConfig finalConfig = config;
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListDocumentsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListDocumentsConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList(parent, (ListDocumentsConfig)requestConfig).thenApply(JsonSerializable::toJsonNode);
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.DOCUMENTS, request, (ObjectNode)JsonSerializable.toJsonNode(finalConfig), (CompletableFuture)request.apply(finalConfig)));
    }
}

