/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_VeoTuningSpec;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.VeoHyperParameters;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class VeoTuningSpec
extends JsonSerializable {
    @JsonProperty(value="hyperParameters")
    public abstract Optional<VeoHyperParameters> hyperParameters();

    @JsonProperty(value="trainingDatasetUri")
    public abstract Optional<String> trainingDatasetUri();

    @JsonProperty(value="validationDatasetUri")
    public abstract Optional<String> validationDatasetUri();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_VeoTuningSpec.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static VeoTuningSpec fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, VeoTuningSpec.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_VeoTuningSpec.Builder();
        }

        @JsonProperty(value="hyperParameters")
        public abstract Builder hyperParameters(VeoHyperParameters var1);

        @CanIgnoreReturnValue
        public Builder hyperParameters(VeoHyperParameters.Builder hyperParametersBuilder) {
            return this.hyperParameters(hyperParametersBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder hyperParameters(Optional<VeoHyperParameters> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHyperParameters() {
            return this.hyperParameters(Optional.empty());
        }

        @JsonProperty(value="trainingDatasetUri")
        public abstract Builder trainingDatasetUri(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder trainingDatasetUri(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTrainingDatasetUri() {
            return this.trainingDatasetUri(Optional.empty());
        }

        @JsonProperty(value="validationDatasetUri")
        public abstract Builder validationDatasetUri(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder validationDatasetUri(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearValidationDatasetUri() {
            return this.validationDatasetUri(Optional.empty());
        }

        public abstract VeoTuningSpec build();
    }
}

