/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_TuningJob;
import com.google.genai.types.EncryptionSpec;
import com.google.genai.types.EvaluationConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GoogleRpcStatus;
import com.google.genai.types.HttpResponse;
import com.google.genai.types.JobState;
import com.google.genai.types.PartnerModelTuningSpec;
import com.google.genai.types.PreTunedModel;
import com.google.genai.types.PreferenceOptimizationSpec;
import com.google.genai.types.SupervisedTuningSpec;
import com.google.genai.types.TunedModel;
import com.google.genai.types.TuningDataStats;
import com.google.genai.types.VeoTuningSpec;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class TuningJob
extends JsonSerializable {
    @JsonProperty(value="sdkHttpResponse")
    public abstract Optional<HttpResponse> sdkHttpResponse();

    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="state")
    public abstract Optional<JobState> state();

    @JsonProperty(value="createTime")
    public abstract Optional<Instant> createTime();

    @JsonProperty(value="startTime")
    public abstract Optional<Instant> startTime();

    @JsonProperty(value="endTime")
    public abstract Optional<Instant> endTime();

    @JsonProperty(value="updateTime")
    public abstract Optional<Instant> updateTime();

    @JsonProperty(value="error")
    public abstract Optional<GoogleRpcStatus> error();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="baseModel")
    public abstract Optional<String> baseModel();

    @JsonProperty(value="tunedModel")
    public abstract Optional<TunedModel> tunedModel();

    @JsonProperty(value="preTunedModel")
    public abstract Optional<PreTunedModel> preTunedModel();

    @JsonProperty(value="supervisedTuningSpec")
    public abstract Optional<SupervisedTuningSpec> supervisedTuningSpec();

    @JsonProperty(value="preferenceOptimizationSpec")
    public abstract Optional<PreferenceOptimizationSpec> preferenceOptimizationSpec();

    @JsonProperty(value="tuningDataStats")
    public abstract Optional<TuningDataStats> tuningDataStats();

    @JsonProperty(value="encryptionSpec")
    public abstract Optional<EncryptionSpec> encryptionSpec();

    @JsonProperty(value="partnerModelTuningSpec")
    public abstract Optional<PartnerModelTuningSpec> partnerModelTuningSpec();

    @JsonProperty(value="evaluationConfig")
    public abstract Optional<EvaluationConfig> evaluationConfig();

    @JsonProperty(value="customBaseModel")
    public abstract Optional<String> customBaseModel();

    @JsonProperty(value="experiment")
    public abstract Optional<String> experiment();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @JsonProperty(value="outputUri")
    public abstract Optional<String> outputUri();

    @JsonProperty(value="pipelineJob")
    public abstract Optional<String> pipelineJob();

    @JsonProperty(value="serviceAccount")
    public abstract Optional<String> serviceAccount();

    @JsonProperty(value="tunedModelDisplayName")
    public abstract Optional<String> tunedModelDisplayName();

    @JsonProperty(value="veoTuningSpec")
    public abstract Optional<VeoTuningSpec> veoTuningSpec();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_TuningJob.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static TuningJob fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, TuningJob.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_TuningJob.Builder();
        }

        @JsonProperty(value="sdkHttpResponse")
        public abstract Builder sdkHttpResponse(HttpResponse var1);

        @CanIgnoreReturnValue
        public Builder sdkHttpResponse(HttpResponse.Builder sdkHttpResponseBuilder) {
            return this.sdkHttpResponse(sdkHttpResponseBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sdkHttpResponse(Optional<HttpResponse> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSdkHttpResponse() {
            return this.sdkHttpResponse(Optional.empty());
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="state")
        public abstract Builder state(JobState var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder state(Optional<JobState> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearState() {
            return this.state(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder state(JobState.Known knownType) {
            return this.state(new JobState(knownType));
        }

        @CanIgnoreReturnValue
        public Builder state(String state) {
            return this.state(new JobState(state));
        }

        @JsonProperty(value="createTime")
        public abstract Builder createTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder createTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCreateTime() {
            return this.createTime(Optional.empty());
        }

        @JsonProperty(value="startTime")
        public abstract Builder startTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder startTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearStartTime() {
            return this.startTime(Optional.empty());
        }

        @JsonProperty(value="endTime")
        public abstract Builder endTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder endTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEndTime() {
            return this.endTime(Optional.empty());
        }

        @JsonProperty(value="updateTime")
        public abstract Builder updateTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder updateTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUpdateTime() {
            return this.updateTime(Optional.empty());
        }

        @JsonProperty(value="error")
        public abstract Builder error(GoogleRpcStatus var1);

        @CanIgnoreReturnValue
        public Builder error(GoogleRpcStatus.Builder errorBuilder) {
            return this.error(errorBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder error(Optional<GoogleRpcStatus> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearError() {
            return this.error(Optional.empty());
        }

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder description(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDescription() {
            return this.description(Optional.empty());
        }

        @JsonProperty(value="baseModel")
        public abstract Builder baseModel(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder baseModel(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBaseModel() {
            return this.baseModel(Optional.empty());
        }

        @JsonProperty(value="tunedModel")
        public abstract Builder tunedModel(TunedModel var1);

        @CanIgnoreReturnValue
        public Builder tunedModel(TunedModel.Builder tunedModelBuilder) {
            return this.tunedModel(tunedModelBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tunedModel(Optional<TunedModel> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTunedModel() {
            return this.tunedModel(Optional.empty());
        }

        @JsonProperty(value="preTunedModel")
        public abstract Builder preTunedModel(PreTunedModel var1);

        @CanIgnoreReturnValue
        public Builder preTunedModel(PreTunedModel.Builder preTunedModelBuilder) {
            return this.preTunedModel(preTunedModelBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder preTunedModel(Optional<PreTunedModel> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPreTunedModel() {
            return this.preTunedModel(Optional.empty());
        }

        @JsonProperty(value="supervisedTuningSpec")
        public abstract Builder supervisedTuningSpec(SupervisedTuningSpec var1);

        @CanIgnoreReturnValue
        public Builder supervisedTuningSpec(SupervisedTuningSpec.Builder supervisedTuningSpecBuilder) {
            return this.supervisedTuningSpec(supervisedTuningSpecBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder supervisedTuningSpec(Optional<SupervisedTuningSpec> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSupervisedTuningSpec() {
            return this.supervisedTuningSpec(Optional.empty());
        }

        @JsonProperty(value="preferenceOptimizationSpec")
        public abstract Builder preferenceOptimizationSpec(PreferenceOptimizationSpec var1);

        @CanIgnoreReturnValue
        public Builder preferenceOptimizationSpec(PreferenceOptimizationSpec.Builder preferenceOptimizationSpecBuilder) {
            return this.preferenceOptimizationSpec(preferenceOptimizationSpecBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder preferenceOptimizationSpec(Optional<PreferenceOptimizationSpec> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPreferenceOptimizationSpec() {
            return this.preferenceOptimizationSpec(Optional.empty());
        }

        @JsonProperty(value="tuningDataStats")
        public abstract Builder tuningDataStats(TuningDataStats var1);

        @CanIgnoreReturnValue
        public Builder tuningDataStats(TuningDataStats.Builder tuningDataStatsBuilder) {
            return this.tuningDataStats(tuningDataStatsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tuningDataStats(Optional<TuningDataStats> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTuningDataStats() {
            return this.tuningDataStats(Optional.empty());
        }

        @JsonProperty(value="encryptionSpec")
        public abstract Builder encryptionSpec(EncryptionSpec var1);

        @CanIgnoreReturnValue
        public Builder encryptionSpec(EncryptionSpec.Builder encryptionSpecBuilder) {
            return this.encryptionSpec(encryptionSpecBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder encryptionSpec(Optional<EncryptionSpec> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEncryptionSpec() {
            return this.encryptionSpec(Optional.empty());
        }

        @JsonProperty(value="partnerModelTuningSpec")
        public abstract Builder partnerModelTuningSpec(PartnerModelTuningSpec var1);

        @CanIgnoreReturnValue
        public Builder partnerModelTuningSpec(PartnerModelTuningSpec.Builder partnerModelTuningSpecBuilder) {
            return this.partnerModelTuningSpec(partnerModelTuningSpecBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder partnerModelTuningSpec(Optional<PartnerModelTuningSpec> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPartnerModelTuningSpec() {
            return this.partnerModelTuningSpec(Optional.empty());
        }

        @JsonProperty(value="evaluationConfig")
        public abstract Builder evaluationConfig(EvaluationConfig var1);

        @CanIgnoreReturnValue
        public Builder evaluationConfig(EvaluationConfig.Builder evaluationConfigBuilder) {
            return this.evaluationConfig(evaluationConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder evaluationConfig(Optional<EvaluationConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEvaluationConfig() {
            return this.evaluationConfig(Optional.empty());
        }

        @JsonProperty(value="customBaseModel")
        public abstract Builder customBaseModel(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder customBaseModel(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCustomBaseModel() {
            return this.customBaseModel(Optional.empty());
        }

        @JsonProperty(value="experiment")
        public abstract Builder experiment(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder experiment(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExperiment() {
            return this.experiment(Optional.empty());
        }

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder labels(Optional<Map<String, String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLabels() {
            return this.labels(Optional.empty());
        }

        @JsonProperty(value="outputUri")
        public abstract Builder outputUri(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputUri(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputUri() {
            return this.outputUri(Optional.empty());
        }

        @JsonProperty(value="pipelineJob")
        public abstract Builder pipelineJob(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder pipelineJob(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPipelineJob() {
            return this.pipelineJob(Optional.empty());
        }

        @JsonProperty(value="serviceAccount")
        public abstract Builder serviceAccount(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder serviceAccount(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearServiceAccount() {
            return this.serviceAccount(Optional.empty());
        }

        @JsonProperty(value="tunedModelDisplayName")
        public abstract Builder tunedModelDisplayName(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tunedModelDisplayName(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTunedModelDisplayName() {
            return this.tunedModelDisplayName(Optional.empty());
        }

        @JsonProperty(value="veoTuningSpec")
        public abstract Builder veoTuningSpec(VeoTuningSpec var1);

        @CanIgnoreReturnValue
        public Builder veoTuningSpec(VeoTuningSpec.Builder veoTuningSpecBuilder) {
            return this.veoTuningSpec(veoTuningSpecBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder veoTuningSpec(Optional<VeoTuningSpec> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVeoTuningSpec() {
            return this.veoTuningSpec(Optional.empty());
        }

        public abstract TuningJob build();
    }
}

