/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_TestTableFile;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.TestTableItem;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class TestTableFile
extends JsonSerializable {
    @JsonProperty(value="comment")
    public abstract Optional<String> comment();

    @JsonProperty(value="testMethod")
    public abstract Optional<String> testMethod();

    @JsonProperty(value="parameterNames")
    public abstract Optional<List<String>> parameterNames();

    @JsonProperty(value="testTable")
    public abstract Optional<List<TestTableItem>> testTable();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_TestTableFile.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static TestTableFile fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, TestTableFile.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_TestTableFile.Builder();
        }

        @JsonProperty(value="comment")
        public abstract Builder comment(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder comment(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearComment() {
            return this.comment(Optional.empty());
        }

        @JsonProperty(value="testMethod")
        public abstract Builder testMethod(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder testMethod(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTestMethod() {
            return this.testMethod(Optional.empty());
        }

        @JsonProperty(value="parameterNames")
        public abstract Builder parameterNames(List<String> var1);

        @CanIgnoreReturnValue
        public Builder parameterNames(String ... parameterNames) {
            return this.parameterNames(Arrays.asList(parameterNames));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder parameterNames(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearParameterNames() {
            return this.parameterNames(Optional.empty());
        }

        @JsonProperty(value="testTable")
        public abstract Builder testTable(List<TestTableItem> var1);

        @CanIgnoreReturnValue
        public Builder testTable(TestTableItem ... testTable) {
            return this.testTable(Arrays.asList(testTable));
        }

        @CanIgnoreReturnValue
        public Builder testTable(TestTableItem.Builder ... testTableBuilders) {
            return this.testTable((List)Arrays.asList(testTableBuilders).stream().map(TestTableItem.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder testTable(Optional<List<TestTableItem>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTestTable() {
            return this.testTable(Optional.empty());
        }

        public abstract TestTableFile build();
    }
}

