/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AdapterSize;
import com.google.genai.types.AutoValue_SupervisedHyperParameters;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.util.Optional;

@InternalApi
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SupervisedHyperParameters
extends JsonSerializable {
    @JsonProperty(value="adapterSize")
    public abstract Optional<AdapterSize> adapterSize();

    @JsonProperty(value="batchSize")
    public abstract Optional<Long> batchSize();

    @JsonProperty(value="epochCount")
    public abstract Optional<Long> epochCount();

    @JsonProperty(value="learningRate")
    public abstract Optional<Double> learningRate();

    @JsonProperty(value="learningRateMultiplier")
    public abstract Optional<Double> learningRateMultiplier();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_SupervisedHyperParameters.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static SupervisedHyperParameters fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, SupervisedHyperParameters.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_SupervisedHyperParameters.Builder();
        }

        @JsonProperty(value="adapterSize")
        public abstract Builder adapterSize(AdapterSize var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder adapterSize(Optional<AdapterSize> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAdapterSize() {
            return this.adapterSize(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder adapterSize(AdapterSize.Known knownType) {
            return this.adapterSize(new AdapterSize(knownType));
        }

        @CanIgnoreReturnValue
        public Builder adapterSize(String adapterSize) {
            return this.adapterSize(new AdapterSize(adapterSize));
        }

        @JsonProperty(value="batchSize")
        public abstract Builder batchSize(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder batchSize(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBatchSize() {
            return this.batchSize(Optional.empty());
        }

        @JsonProperty(value="epochCount")
        public abstract Builder epochCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder epochCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEpochCount() {
            return this.epochCount(Optional.empty());
        }

        @JsonProperty(value="learningRate")
        public abstract Builder learningRate(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder learningRate(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLearningRate() {
            return this.learningRate(Optional.empty());
        }

        @JsonProperty(value="learningRateMultiplier")
        public abstract Builder learningRateMultiplier(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder learningRateMultiplier(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLearningRateMultiplier() {
            return this.learningRateMultiplier(Optional.empty());
        }

        public abstract SupervisedHyperParameters build();
    }
}

