/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_SpeechConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.MultiSpeakerVoiceConfig;
import com.google.genai.types.VoiceConfig;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SpeechConfig
extends JsonSerializable {
    @JsonProperty(value="languageCode")
    public abstract Optional<String> languageCode();

    @JsonProperty(value="voiceConfig")
    public abstract Optional<VoiceConfig> voiceConfig();

    @JsonProperty(value="multiSpeakerVoiceConfig")
    public abstract Optional<MultiSpeakerVoiceConfig> multiSpeakerVoiceConfig();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_SpeechConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static SpeechConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, SpeechConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_SpeechConfig.Builder();
        }

        @JsonProperty(value="languageCode")
        public abstract Builder languageCode(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder languageCode(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLanguageCode() {
            return this.languageCode(Optional.empty());
        }

        @JsonProperty(value="voiceConfig")
        public abstract Builder voiceConfig(VoiceConfig var1);

        @CanIgnoreReturnValue
        public Builder voiceConfig(VoiceConfig.Builder voiceConfigBuilder) {
            return this.voiceConfig(voiceConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder voiceConfig(Optional<VoiceConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVoiceConfig() {
            return this.voiceConfig(Optional.empty());
        }

        @JsonProperty(value="multiSpeakerVoiceConfig")
        public abstract Builder multiSpeakerVoiceConfig(MultiSpeakerVoiceConfig var1);

        @CanIgnoreReturnValue
        public Builder multiSpeakerVoiceConfig(MultiSpeakerVoiceConfig.Builder multiSpeakerVoiceConfigBuilder) {
            return this.multiSpeakerVoiceConfig(multiSpeakerVoiceConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder multiSpeakerVoiceConfig(Optional<MultiSpeakerVoiceConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMultiSpeakerVoiceConfig() {
            return this.multiSpeakerVoiceConfig(Optional.empty());
        }

        public abstract SpeechConfig build();
    }
}

