/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_SegmentImageSource;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Image;
import com.google.genai.types.ScribbleImage;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SegmentImageSource
extends JsonSerializable {
    @JsonProperty(value="prompt")
    public abstract Optional<String> prompt();

    @JsonProperty(value="image")
    public abstract Optional<Image> image();

    @JsonProperty(value="scribbleImage")
    public abstract Optional<ScribbleImage> scribbleImage();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_SegmentImageSource.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static SegmentImageSource fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, SegmentImageSource.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_SegmentImageSource.Builder();
        }

        @JsonProperty(value="prompt")
        public abstract Builder prompt(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder prompt(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPrompt() {
            return this.prompt(Optional.empty());
        }

        @JsonProperty(value="image")
        public abstract Builder image(Image var1);

        @CanIgnoreReturnValue
        public Builder image(Image.Builder imageBuilder) {
            return this.image(imageBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder image(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearImage() {
            return this.image(Optional.empty());
        }

        @JsonProperty(value="scribbleImage")
        public abstract Builder scribbleImage(ScribbleImage var1);

        @CanIgnoreReturnValue
        public Builder scribbleImage(ScribbleImage.Builder scribbleImageBuilder) {
            return this.scribbleImage(scribbleImageBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder scribbleImage(Optional<ScribbleImage> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearScribbleImage() {
            return this.scribbleImage(Optional.empty());
        }

        public abstract SegmentImageSource build();
    }
}

