/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_ReplayResponse;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ReplayResponse
extends JsonSerializable {
    @JsonProperty(value="status_code")
    public abstract Optional<Integer> statusCode();

    @JsonProperty(value="headers")
    public abstract Optional<Map<String, String>> headers();

    @JsonProperty(value="body_segments")
    public abstract Optional<List<Map<String, Object>>> bodySegments();

    @JsonProperty(value="sdk_response_segments")
    public abstract Optional<List<Map<String, Object>>> sdkResponseSegments();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_ReplayResponse.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static ReplayResponse fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, ReplayResponse.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_ReplayResponse.Builder();
        }

        @JsonProperty(value="status_code")
        public abstract Builder statusCode(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder statusCode(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearStatusCode() {
            return this.statusCode(Optional.empty());
        }

        @JsonProperty(value="headers")
        public abstract Builder headers(Map<String, String> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder headers(Optional<Map<String, String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHeaders() {
            return this.headers(Optional.empty());
        }

        @JsonProperty(value="body_segments")
        public abstract Builder bodySegments(List<Map<String, Object>> var1);

        @CanIgnoreReturnValue
        public Builder bodySegments(Map<String, Object> ... bodySegments) {
            return this.bodySegments(Arrays.asList(bodySegments));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder bodySegments(Optional<List<Map<String, Object>>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBodySegments() {
            return this.bodySegments(Optional.empty());
        }

        @JsonProperty(value="sdk_response_segments")
        public abstract Builder sdkResponseSegments(List<Map<String, Object>> var1);

        @CanIgnoreReturnValue
        public Builder sdkResponseSegments(Map<String, Object> ... sdkResponseSegments) {
            return this.sdkResponseSegments(Arrays.asList(sdkResponseSegments));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sdkResponseSegments(Optional<List<Map<String, Object>>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSdkResponseSegments() {
            return this.sdkResponseSegments(Optional.empty());
        }

        public abstract ReplayResponse build();
    }
}

