/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Metric;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Metric
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="promptTemplate")
    public abstract Optional<String> promptTemplate();

    @JsonProperty(value="judgeModelSystemInstruction")
    public abstract Optional<String> judgeModelSystemInstruction();

    @JsonProperty(value="returnRawOutput")
    public abstract Optional<Boolean> returnRawOutput();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Metric.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Metric fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Metric.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Metric.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="promptTemplate")
        public abstract Builder promptTemplate(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder promptTemplate(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPromptTemplate() {
            return this.promptTemplate(Optional.empty());
        }

        @JsonProperty(value="judgeModelSystemInstruction")
        public abstract Builder judgeModelSystemInstruction(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder judgeModelSystemInstruction(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearJudgeModelSystemInstruction() {
            return this.judgeModelSystemInstruction(Optional.empty());
        }

        @JsonProperty(value="returnRawOutput")
        public abstract Builder returnRawOutput(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder returnRawOutput(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReturnRawOutput() {
            return this.returnRawOutput(Optional.empty());
        }

        public abstract Metric build();
    }
}

