/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_MaskReferenceImage;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Image;
import com.google.genai.types.MaskReferenceConfig;
import com.google.genai.types.ReferenceImage;
import com.google.genai.types.ReferenceImageAPI;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class MaskReferenceImage
extends JsonSerializable
implements ReferenceImage {
    @JsonProperty(value="referenceImage")
    public abstract Optional<Image> referenceImage();

    @JsonProperty(value="referenceId")
    public abstract Optional<Integer> referenceId();

    @JsonProperty(value="referenceType")
    public abstract Optional<String> referenceType();

    @JsonProperty(value="config")
    public abstract Optional<MaskReferenceConfig> config();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_MaskReferenceImage.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static MaskReferenceImage fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, MaskReferenceImage.class);
    }

    @Override
    public ReferenceImageAPI toReferenceImageAPI() {
        ReferenceImageAPI.Builder referenceImageAPIBuilder = ReferenceImageAPI.builder();
        this.referenceImage().ifPresent(referenceImageAPIBuilder::referenceImage);
        this.referenceId().ifPresent(referenceImageAPIBuilder::referenceId);
        this.config().ifPresent(referenceImageAPIBuilder::maskImageConfig);
        referenceImageAPIBuilder.referenceType("REFERENCE_TYPE_MASK");
        return referenceImageAPIBuilder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_MaskReferenceImage.Builder();
        }

        @JsonProperty(value="referenceImage")
        public abstract Builder referenceImage(Image var1);

        @CanIgnoreReturnValue
        public Builder referenceImage(Image.Builder referenceImageBuilder) {
            return this.referenceImage(referenceImageBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceImage(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceImage() {
            return this.referenceImage(Optional.empty());
        }

        @JsonProperty(value="referenceId")
        public abstract Builder referenceId(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceId(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceId() {
            return this.referenceId(Optional.empty());
        }

        @JsonProperty(value="referenceType")
        public abstract Builder referenceType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceType() {
            return this.referenceType(Optional.empty());
        }

        @JsonProperty(value="config")
        public abstract Builder config(MaskReferenceConfig var1);

        @CanIgnoreReturnValue
        public Builder config(MaskReferenceConfig.Builder configBuilder) {
            return this.config(configBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder config(Optional<MaskReferenceConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearConfig() {
            return this.config(Optional.empty());
        }

        public abstract MaskReferenceImage build();
    }
}

