/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_MaskReferenceConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.MaskReferenceMode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class MaskReferenceConfig
extends JsonSerializable {
    @JsonProperty(value="maskMode")
    public abstract Optional<MaskReferenceMode> maskMode();

    @JsonProperty(value="segmentationClasses")
    public abstract Optional<List<Integer>> segmentationClasses();

    @JsonProperty(value="maskDilation")
    public abstract Optional<Float> maskDilation();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_MaskReferenceConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static MaskReferenceConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, MaskReferenceConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_MaskReferenceConfig.Builder();
        }

        @JsonProperty(value="maskMode")
        public abstract Builder maskMode(MaskReferenceMode var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maskMode(Optional<MaskReferenceMode> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaskMode() {
            return this.maskMode(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder maskMode(MaskReferenceMode.Known knownType) {
            return this.maskMode(new MaskReferenceMode(knownType));
        }

        @CanIgnoreReturnValue
        public Builder maskMode(String maskMode) {
            return this.maskMode(new MaskReferenceMode(maskMode));
        }

        @JsonProperty(value="segmentationClasses")
        public abstract Builder segmentationClasses(List<Integer> var1);

        @CanIgnoreReturnValue
        public Builder segmentationClasses(Integer ... segmentationClasses) {
            return this.segmentationClasses(Arrays.asList(segmentationClasses));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder segmentationClasses(Optional<List<Integer>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSegmentationClasses() {
            return this.segmentationClasses(Optional.empty());
        }

        @JsonProperty(value="maskDilation")
        public abstract Builder maskDilation(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maskDilation(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaskDilation() {
            return this.maskDilation(Optional.empty());
        }

        public abstract MaskReferenceConfig build();
    }
}

