/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_LiveServerMessage;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.LiveServerContent;
import com.google.genai.types.LiveServerGoAway;
import com.google.genai.types.LiveServerSessionResumptionUpdate;
import com.google.genai.types.LiveServerSetupComplete;
import com.google.genai.types.LiveServerToolCall;
import com.google.genai.types.LiveServerToolCallCancellation;
import com.google.genai.types.UsageMetadata;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveServerMessage
extends JsonSerializable {
    @JsonProperty(value="setupComplete")
    public abstract Optional<LiveServerSetupComplete> setupComplete();

    @JsonProperty(value="serverContent")
    public abstract Optional<LiveServerContent> serverContent();

    @JsonProperty(value="toolCall")
    public abstract Optional<LiveServerToolCall> toolCall();

    @JsonProperty(value="toolCallCancellation")
    public abstract Optional<LiveServerToolCallCancellation> toolCallCancellation();

    @JsonProperty(value="usageMetadata")
    public abstract Optional<UsageMetadata> usageMetadata();

    @JsonProperty(value="goAway")
    public abstract Optional<LiveServerGoAway> goAway();

    @JsonProperty(value="sessionResumptionUpdate")
    public abstract Optional<LiveServerSessionResumptionUpdate> sessionResumptionUpdate();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_LiveServerMessage.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static LiveServerMessage fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, LiveServerMessage.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_LiveServerMessage.Builder();
        }

        @JsonProperty(value="setupComplete")
        public abstract Builder setupComplete(LiveServerSetupComplete var1);

        @CanIgnoreReturnValue
        public Builder setupComplete(LiveServerSetupComplete.Builder setupCompleteBuilder) {
            return this.setupComplete(setupCompleteBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder setupComplete(Optional<LiveServerSetupComplete> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSetupComplete() {
            return this.setupComplete(Optional.empty());
        }

        @JsonProperty(value="serverContent")
        public abstract Builder serverContent(LiveServerContent var1);

        @CanIgnoreReturnValue
        public Builder serverContent(LiveServerContent.Builder serverContentBuilder) {
            return this.serverContent(serverContentBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder serverContent(Optional<LiveServerContent> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearServerContent() {
            return this.serverContent(Optional.empty());
        }

        @JsonProperty(value="toolCall")
        public abstract Builder toolCall(LiveServerToolCall var1);

        @CanIgnoreReturnValue
        public Builder toolCall(LiveServerToolCall.Builder toolCallBuilder) {
            return this.toolCall(toolCallBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder toolCall(Optional<LiveServerToolCall> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearToolCall() {
            return this.toolCall(Optional.empty());
        }

        @JsonProperty(value="toolCallCancellation")
        public abstract Builder toolCallCancellation(LiveServerToolCallCancellation var1);

        @CanIgnoreReturnValue
        public Builder toolCallCancellation(LiveServerToolCallCancellation.Builder toolCallCancellationBuilder) {
            return this.toolCallCancellation(toolCallCancellationBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder toolCallCancellation(Optional<LiveServerToolCallCancellation> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearToolCallCancellation() {
            return this.toolCallCancellation(Optional.empty());
        }

        @JsonProperty(value="usageMetadata")
        public abstract Builder usageMetadata(UsageMetadata var1);

        @CanIgnoreReturnValue
        public Builder usageMetadata(UsageMetadata.Builder usageMetadataBuilder) {
            return this.usageMetadata(usageMetadataBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder usageMetadata(Optional<UsageMetadata> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUsageMetadata() {
            return this.usageMetadata(Optional.empty());
        }

        @JsonProperty(value="goAway")
        public abstract Builder goAway(LiveServerGoAway var1);

        @CanIgnoreReturnValue
        public Builder goAway(LiveServerGoAway.Builder goAwayBuilder) {
            return this.goAway(goAwayBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder goAway(Optional<LiveServerGoAway> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGoAway() {
            return this.goAway(Optional.empty());
        }

        @JsonProperty(value="sessionResumptionUpdate")
        public abstract Builder sessionResumptionUpdate(LiveServerSessionResumptionUpdate var1);

        @CanIgnoreReturnValue
        public Builder sessionResumptionUpdate(LiveServerSessionResumptionUpdate.Builder sessionResumptionUpdateBuilder) {
            return this.sessionResumptionUpdate(sessionResumptionUpdateBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sessionResumptionUpdate(Optional<LiveServerSessionResumptionUpdate> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSessionResumptionUpdate() {
            return this.sessionResumptionUpdate(Optional.empty());
        }

        public abstract LiveServerMessage build();
    }
}

