/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerationConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GenerationConfigRoutingConfig;
import com.google.genai.types.MediaResolution;
import com.google.genai.types.Modality;
import com.google.genai.types.ModelSelectionConfig;
import com.google.genai.types.Schema;
import com.google.genai.types.SpeechConfig;
import com.google.genai.types.ThinkingConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerationConfig
extends JsonSerializable {
    @JsonProperty(value="modelSelectionConfig")
    public abstract Optional<ModelSelectionConfig> modelSelectionConfig();

    @JsonProperty(value="responseJsonSchema")
    public abstract Optional<Object> responseJsonSchema();

    @JsonProperty(value="audioTimestamp")
    public abstract Optional<Boolean> audioTimestamp();

    @JsonProperty(value="candidateCount")
    public abstract Optional<Integer> candidateCount();

    @JsonProperty(value="enableAffectiveDialog")
    public abstract Optional<Boolean> enableAffectiveDialog();

    @JsonProperty(value="frequencyPenalty")
    public abstract Optional<Float> frequencyPenalty();

    @JsonProperty(value="logprobs")
    public abstract Optional<Integer> logprobs();

    @JsonProperty(value="maxOutputTokens")
    public abstract Optional<Integer> maxOutputTokens();

    @JsonProperty(value="mediaResolution")
    public abstract Optional<MediaResolution> mediaResolution();

    @JsonProperty(value="presencePenalty")
    public abstract Optional<Float> presencePenalty();

    @JsonProperty(value="responseLogprobs")
    public abstract Optional<Boolean> responseLogprobs();

    @JsonProperty(value="responseMimeType")
    public abstract Optional<String> responseMimeType();

    @JsonProperty(value="responseModalities")
    public abstract Optional<List<Modality>> responseModalities();

    @JsonProperty(value="responseSchema")
    public abstract Optional<Schema> responseSchema();

    @JsonProperty(value="routingConfig")
    public abstract Optional<GenerationConfigRoutingConfig> routingConfig();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="speechConfig")
    public abstract Optional<SpeechConfig> speechConfig();

    @JsonProperty(value="stopSequences")
    public abstract Optional<List<String>> stopSequences();

    @JsonProperty(value="temperature")
    public abstract Optional<Float> temperature();

    @JsonProperty(value="thinkingConfig")
    public abstract Optional<ThinkingConfig> thinkingConfig();

    @JsonProperty(value="topK")
    public abstract Optional<Float> topK();

    @JsonProperty(value="topP")
    public abstract Optional<Float> topP();

    @JsonProperty(value="enableEnhancedCivicAnswers")
    public abstract Optional<Boolean> enableEnhancedCivicAnswers();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GenerationConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GenerationConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerationConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerationConfig.Builder();
        }

        @JsonProperty(value="modelSelectionConfig")
        public abstract Builder modelSelectionConfig(ModelSelectionConfig var1);

        @CanIgnoreReturnValue
        public Builder modelSelectionConfig(ModelSelectionConfig.Builder modelSelectionConfigBuilder) {
            return this.modelSelectionConfig(modelSelectionConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder modelSelectionConfig(Optional<ModelSelectionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearModelSelectionConfig() {
            return this.modelSelectionConfig(Optional.empty());
        }

        @JsonProperty(value="responseJsonSchema")
        public abstract Builder responseJsonSchema(Object var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseJsonSchema(Optional<Object> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseJsonSchema() {
            return this.responseJsonSchema(Optional.empty());
        }

        @JsonProperty(value="audioTimestamp")
        public abstract Builder audioTimestamp(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder audioTimestamp(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAudioTimestamp() {
            return this.audioTimestamp(Optional.empty());
        }

        @JsonProperty(value="candidateCount")
        public abstract Builder candidateCount(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder candidateCount(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCandidateCount() {
            return this.candidateCount(Optional.empty());
        }

        @JsonProperty(value="enableAffectiveDialog")
        public abstract Builder enableAffectiveDialog(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder enableAffectiveDialog(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEnableAffectiveDialog() {
            return this.enableAffectiveDialog(Optional.empty());
        }

        @JsonProperty(value="frequencyPenalty")
        public abstract Builder frequencyPenalty(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder frequencyPenalty(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFrequencyPenalty() {
            return this.frequencyPenalty(Optional.empty());
        }

        @JsonProperty(value="logprobs")
        public abstract Builder logprobs(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder logprobs(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLogprobs() {
            return this.logprobs(Optional.empty());
        }

        @JsonProperty(value="maxOutputTokens")
        public abstract Builder maxOutputTokens(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxOutputTokens(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxOutputTokens() {
            return this.maxOutputTokens(Optional.empty());
        }

        @JsonProperty(value="mediaResolution")
        public abstract Builder mediaResolution(MediaResolution var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mediaResolution(Optional<MediaResolution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMediaResolution() {
            return this.mediaResolution(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(MediaResolution.Known knownType) {
            return this.mediaResolution(new MediaResolution(knownType));
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(String mediaResolution) {
            return this.mediaResolution(new MediaResolution(mediaResolution));
        }

        @JsonProperty(value="presencePenalty")
        public abstract Builder presencePenalty(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder presencePenalty(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPresencePenalty() {
            return this.presencePenalty(Optional.empty());
        }

        @JsonProperty(value="responseLogprobs")
        public abstract Builder responseLogprobs(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseLogprobs(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseLogprobs() {
            return this.responseLogprobs(Optional.empty());
        }

        @JsonProperty(value="responseMimeType")
        public abstract Builder responseMimeType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseMimeType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseMimeType() {
            return this.responseMimeType(Optional.empty());
        }

        @JsonProperty(value="responseModalities")
        public abstract Builder responseModalities(List<Modality> var1);

        @CanIgnoreReturnValue
        public Builder responseModalities(Modality ... responseModalities) {
            return this.responseModalities(Arrays.asList(responseModalities));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseModalities(Optional<List<Modality>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseModalities() {
            return this.responseModalities(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder responseModalities(String ... responseModalities) {
            return this.responseModalitiesFromString(Arrays.asList(responseModalities));
        }

        @CanIgnoreReturnValue
        public Builder responseModalities(Modality.Known ... knownTypes) {
            return this.responseModalitiesFromKnown(Arrays.asList(knownTypes));
        }

        @CanIgnoreReturnValue
        public Builder responseModalitiesFromKnown(List<Modality.Known> knownTypes) {
            ImmutableList listItems = (ImmutableList)knownTypes.stream().map(Modality::new).collect(ImmutableList.toImmutableList());
            return this.responseModalities((List<Modality>)listItems);
        }

        @CanIgnoreReturnValue
        public Builder responseModalitiesFromString(List<String> responseModalities) {
            ImmutableList listItems = (ImmutableList)responseModalities.stream().map(Modality::new).collect(ImmutableList.toImmutableList());
            return this.responseModalities((List<Modality>)listItems);
        }

        @JsonProperty(value="responseSchema")
        public abstract Builder responseSchema(Schema var1);

        @CanIgnoreReturnValue
        public Builder responseSchema(Schema.Builder responseSchemaBuilder) {
            return this.responseSchema(responseSchemaBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseSchema(Optional<Schema> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseSchema() {
            return this.responseSchema(Optional.empty());
        }

        @JsonProperty(value="routingConfig")
        public abstract Builder routingConfig(GenerationConfigRoutingConfig var1);

        @CanIgnoreReturnValue
        public Builder routingConfig(GenerationConfigRoutingConfig.Builder routingConfigBuilder) {
            return this.routingConfig(routingConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder routingConfig(Optional<GenerationConfigRoutingConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRoutingConfig() {
            return this.routingConfig(Optional.empty());
        }

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder seed(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSeed() {
            return this.seed(Optional.empty());
        }

        @JsonProperty(value="speechConfig")
        public abstract Builder speechConfig(SpeechConfig var1);

        @CanIgnoreReturnValue
        public Builder speechConfig(SpeechConfig.Builder speechConfigBuilder) {
            return this.speechConfig(speechConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder speechConfig(Optional<SpeechConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSpeechConfig() {
            return this.speechConfig(Optional.empty());
        }

        @JsonProperty(value="stopSequences")
        public abstract Builder stopSequences(List<String> var1);

        @CanIgnoreReturnValue
        public Builder stopSequences(String ... stopSequences) {
            return this.stopSequences(Arrays.asList(stopSequences));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder stopSequences(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearStopSequences() {
            return this.stopSequences(Optional.empty());
        }

        @JsonProperty(value="temperature")
        public abstract Builder temperature(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder temperature(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTemperature() {
            return this.temperature(Optional.empty());
        }

        @JsonProperty(value="thinkingConfig")
        public abstract Builder thinkingConfig(ThinkingConfig var1);

        @CanIgnoreReturnValue
        public Builder thinkingConfig(ThinkingConfig.Builder thinkingConfigBuilder) {
            return this.thinkingConfig(thinkingConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder thinkingConfig(Optional<ThinkingConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearThinkingConfig() {
            return this.thinkingConfig(Optional.empty());
        }

        @JsonProperty(value="topK")
        public abstract Builder topK(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder topK(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTopK() {
            return this.topK(Optional.empty());
        }

        @JsonProperty(value="topP")
        public abstract Builder topP(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder topP(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTopP() {
            return this.topP(Optional.empty());
        }

        @JsonProperty(value="enableEnhancedCivicAnswers")
        public abstract Builder enableEnhancedCivicAnswers(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder enableEnhancedCivicAnswers(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEnableEnhancedCivicAnswers() {
            return this.enableEnhancedCivicAnswers(Optional.empty());
        }

        public abstract GenerationConfig build();
    }
}

