/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GeneratedImageMask;
import com.google.genai.types.EntityLabel;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Image;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GeneratedImageMask
extends JsonSerializable {
    @JsonProperty(value="mask")
    public abstract Optional<Image> mask();

    @JsonProperty(value="labels")
    public abstract Optional<List<EntityLabel>> labels();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GeneratedImageMask.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GeneratedImageMask fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GeneratedImageMask.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GeneratedImageMask.Builder();
        }

        @JsonProperty(value="mask")
        public abstract Builder mask(Image var1);

        @CanIgnoreReturnValue
        public Builder mask(Image.Builder maskBuilder) {
            return this.mask(maskBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mask(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMask() {
            return this.mask(Optional.empty());
        }

        @JsonProperty(value="labels")
        public abstract Builder labels(List<EntityLabel> var1);

        @CanIgnoreReturnValue
        public Builder labels(EntityLabel ... labels) {
            return this.labels(Arrays.asList(labels));
        }

        @CanIgnoreReturnValue
        public Builder labels(EntityLabel.Builder ... labelsBuilders) {
            return this.labels((List)Arrays.asList(labelsBuilders).stream().map(EntityLabel.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder labels(Optional<List<EntityLabel>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLabels() {
            return this.labels(Optional.empty());
        }

        public abstract GeneratedImageMask build();
    }
}

