/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_FileSearchStore;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.time.Instant;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class FileSearchStore
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="displayName")
    public abstract Optional<String> displayName();

    @JsonProperty(value="createTime")
    public abstract Optional<Instant> createTime();

    @JsonProperty(value="updateTime")
    public abstract Optional<Instant> updateTime();

    @JsonProperty(value="activeDocumentsCount")
    public abstract Optional<Long> activeDocumentsCount();

    @JsonProperty(value="pendingDocumentsCount")
    public abstract Optional<Long> pendingDocumentsCount();

    @JsonProperty(value="failedDocumentsCount")
    public abstract Optional<Long> failedDocumentsCount();

    @JsonProperty(value="sizeBytes")
    public abstract Optional<Long> sizeBytes();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_FileSearchStore.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static FileSearchStore fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, FileSearchStore.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_FileSearchStore.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="displayName")
        public abstract Builder displayName(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder displayName(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDisplayName() {
            return this.displayName(Optional.empty());
        }

        @JsonProperty(value="createTime")
        public abstract Builder createTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder createTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCreateTime() {
            return this.createTime(Optional.empty());
        }

        @JsonProperty(value="updateTime")
        public abstract Builder updateTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder updateTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUpdateTime() {
            return this.updateTime(Optional.empty());
        }

        @JsonProperty(value="activeDocumentsCount")
        public abstract Builder activeDocumentsCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder activeDocumentsCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearActiveDocumentsCount() {
            return this.activeDocumentsCount(Optional.empty());
        }

        @JsonProperty(value="pendingDocumentsCount")
        public abstract Builder pendingDocumentsCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder pendingDocumentsCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPendingDocumentsCount() {
            return this.pendingDocumentsCount(Optional.empty());
        }

        @JsonProperty(value="failedDocumentsCount")
        public abstract Builder failedDocumentsCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder failedDocumentsCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFailedDocumentsCount() {
            return this.failedDocumentsCount(Optional.empty());
        }

        @JsonProperty(value="sizeBytes")
        public abstract Builder sizeBytes(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sizeBytes(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSizeBytes() {
            return this.sizeBytes(Optional.empty());
        }

        public abstract FileSearchStore build();
    }
}

