/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AdapterSize;
import com.google.genai.types.AutoValue_CreateTuningJobConfig;
import com.google.genai.types.EvaluationConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.TuningMethod;
import com.google.genai.types.TuningValidationDataset;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class CreateTuningJobConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="method")
    public abstract Optional<TuningMethod> method();

    @JsonProperty(value="validationDataset")
    public abstract Optional<TuningValidationDataset> validationDataset();

    @JsonProperty(value="tunedModelDisplayName")
    public abstract Optional<String> tunedModelDisplayName();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="epochCount")
    public abstract Optional<Integer> epochCount();

    @JsonProperty(value="learningRateMultiplier")
    public abstract Optional<Float> learningRateMultiplier();

    @JsonProperty(value="exportLastCheckpointOnly")
    public abstract Optional<Boolean> exportLastCheckpointOnly();

    @JsonProperty(value="preTunedModelCheckpointId")
    public abstract Optional<String> preTunedModelCheckpointId();

    @JsonProperty(value="adapterSize")
    public abstract Optional<AdapterSize> adapterSize();

    @JsonProperty(value="batchSize")
    public abstract Optional<Integer> batchSize();

    @JsonProperty(value="learningRate")
    public abstract Optional<Float> learningRate();

    @JsonProperty(value="evaluationConfig")
    public abstract Optional<EvaluationConfig> evaluationConfig();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @JsonProperty(value="beta")
    public abstract Optional<Float> beta();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_CreateTuningJobConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static CreateTuningJobConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, CreateTuningJobConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_CreateTuningJobConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @CanIgnoreReturnValue
        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpOptions(Optional<HttpOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpOptions() {
            return this.httpOptions(Optional.empty());
        }

        @JsonProperty(value="method")
        public abstract Builder method(TuningMethod var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder method(Optional<TuningMethod> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMethod() {
            return this.method(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder method(TuningMethod.Known knownType) {
            return this.method(new TuningMethod(knownType));
        }

        @CanIgnoreReturnValue
        public Builder method(String method) {
            return this.method(new TuningMethod(method));
        }

        @JsonProperty(value="validationDataset")
        public abstract Builder validationDataset(TuningValidationDataset var1);

        @CanIgnoreReturnValue
        public Builder validationDataset(TuningValidationDataset.Builder validationDatasetBuilder) {
            return this.validationDataset(validationDatasetBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder validationDataset(Optional<TuningValidationDataset> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearValidationDataset() {
            return this.validationDataset(Optional.empty());
        }

        @JsonProperty(value="tunedModelDisplayName")
        public abstract Builder tunedModelDisplayName(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tunedModelDisplayName(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTunedModelDisplayName() {
            return this.tunedModelDisplayName(Optional.empty());
        }

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder description(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDescription() {
            return this.description(Optional.empty());
        }

        @JsonProperty(value="epochCount")
        public abstract Builder epochCount(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder epochCount(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEpochCount() {
            return this.epochCount(Optional.empty());
        }

        @JsonProperty(value="learningRateMultiplier")
        public abstract Builder learningRateMultiplier(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder learningRateMultiplier(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLearningRateMultiplier() {
            return this.learningRateMultiplier(Optional.empty());
        }

        @JsonProperty(value="exportLastCheckpointOnly")
        public abstract Builder exportLastCheckpointOnly(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder exportLastCheckpointOnly(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExportLastCheckpointOnly() {
            return this.exportLastCheckpointOnly(Optional.empty());
        }

        @JsonProperty(value="preTunedModelCheckpointId")
        public abstract Builder preTunedModelCheckpointId(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder preTunedModelCheckpointId(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPreTunedModelCheckpointId() {
            return this.preTunedModelCheckpointId(Optional.empty());
        }

        @JsonProperty(value="adapterSize")
        public abstract Builder adapterSize(AdapterSize var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder adapterSize(Optional<AdapterSize> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAdapterSize() {
            return this.adapterSize(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder adapterSize(AdapterSize.Known knownType) {
            return this.adapterSize(new AdapterSize(knownType));
        }

        @CanIgnoreReturnValue
        public Builder adapterSize(String adapterSize) {
            return this.adapterSize(new AdapterSize(adapterSize));
        }

        @JsonProperty(value="batchSize")
        public abstract Builder batchSize(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder batchSize(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBatchSize() {
            return this.batchSize(Optional.empty());
        }

        @JsonProperty(value="learningRate")
        public abstract Builder learningRate(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder learningRate(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLearningRate() {
            return this.learningRate(Optional.empty());
        }

        @JsonProperty(value="evaluationConfig")
        public abstract Builder evaluationConfig(EvaluationConfig var1);

        @CanIgnoreReturnValue
        public Builder evaluationConfig(EvaluationConfig.Builder evaluationConfigBuilder) {
            return this.evaluationConfig(evaluationConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder evaluationConfig(Optional<EvaluationConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEvaluationConfig() {
            return this.evaluationConfig(Optional.empty());
        }

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder labels(Optional<Map<String, String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLabels() {
            return this.labels(Optional.empty());
        }

        @JsonProperty(value="beta")
        public abstract Builder beta(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder beta(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBeta() {
            return this.beta(Optional.empty());
        }

        public abstract CreateTuningJobConfig build();
    }
}

