/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.ChunkingConfig;
import com.google.genai.types.CustomMetadata;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.ImportFileConfig;
import java.util.List;
import java.util.Optional;

final class AutoValue_ImportFileConfig
extends ImportFileConfig {
    private final Optional<HttpOptions> httpOptions;
    private final Optional<List<CustomMetadata>> customMetadata;
    private final Optional<ChunkingConfig> chunkingConfig;

    private AutoValue_ImportFileConfig(Optional<HttpOptions> httpOptions, Optional<List<CustomMetadata>> customMetadata, Optional<ChunkingConfig> chunkingConfig) {
        this.httpOptions = httpOptions;
        this.customMetadata = customMetadata;
        this.chunkingConfig = chunkingConfig;
    }

    @Override
    @JsonProperty(value="httpOptions")
    public Optional<HttpOptions> httpOptions() {
        return this.httpOptions;
    }

    @Override
    @JsonProperty(value="customMetadata")
    public Optional<List<CustomMetadata>> customMetadata() {
        return this.customMetadata;
    }

    @Override
    @JsonProperty(value="chunkingConfig")
    public Optional<ChunkingConfig> chunkingConfig() {
        return this.chunkingConfig;
    }

    public String toString() {
        return "ImportFileConfig{httpOptions=" + this.httpOptions + ", customMetadata=" + this.customMetadata + ", chunkingConfig=" + this.chunkingConfig + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImportFileConfig) {
            ImportFileConfig that = (ImportFileConfig)o;
            return this.httpOptions.equals(that.httpOptions()) && this.customMetadata.equals(that.customMetadata()) && this.chunkingConfig.equals(that.chunkingConfig());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.httpOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.customMetadata.hashCode();
        h$ *= 1000003;
        return h$ ^= this.chunkingConfig.hashCode();
    }

    @Override
    public ImportFileConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ImportFileConfig.Builder {
        private Optional<HttpOptions> httpOptions = Optional.empty();
        private Optional<List<CustomMetadata>> customMetadata = Optional.empty();
        private Optional<ChunkingConfig> chunkingConfig = Optional.empty();

        Builder() {
        }

        Builder(ImportFileConfig source) {
            this.httpOptions = source.httpOptions();
            this.customMetadata = source.customMetadata();
            this.chunkingConfig = source.chunkingConfig();
        }

        @Override
        public ImportFileConfig.Builder httpOptions(HttpOptions httpOptions) {
            this.httpOptions = Optional.of(httpOptions);
            return this;
        }

        @Override
        ImportFileConfig.Builder httpOptions(Optional<HttpOptions> httpOptions) {
            if (httpOptions == null) {
                throw new NullPointerException("Null httpOptions");
            }
            this.httpOptions = httpOptions;
            return this;
        }

        @Override
        public ImportFileConfig.Builder customMetadata(List<CustomMetadata> customMetadata) {
            this.customMetadata = Optional.of(customMetadata);
            return this;
        }

        @Override
        ImportFileConfig.Builder customMetadata(Optional<List<CustomMetadata>> customMetadata) {
            if (customMetadata == null) {
                throw new NullPointerException("Null customMetadata");
            }
            this.customMetadata = customMetadata;
            return this;
        }

        @Override
        public ImportFileConfig.Builder chunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = Optional.of(chunkingConfig);
            return this;
        }

        @Override
        ImportFileConfig.Builder chunkingConfig(Optional<ChunkingConfig> chunkingConfig) {
            if (chunkingConfig == null) {
                throw new NullPointerException("Null chunkingConfig");
            }
            this.chunkingConfig = chunkingConfig;
            return this;
        }

        @Override
        public ImportFileConfig build() {
            return new AutoValue_ImportFileConfig(this.httpOptions, this.customMetadata, this.chunkingConfig);
        }
    }
}

