/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.ImageConfig;
import java.util.Optional;

final class AutoValue_ImageConfig
extends ImageConfig {
    private final Optional<String> aspectRatio;
    private final Optional<String> imageSize;
    private final Optional<String> outputMimeType;
    private final Optional<Integer> outputCompressionQuality;

    private AutoValue_ImageConfig(Optional<String> aspectRatio, Optional<String> imageSize, Optional<String> outputMimeType, Optional<Integer> outputCompressionQuality) {
        this.aspectRatio = aspectRatio;
        this.imageSize = imageSize;
        this.outputMimeType = outputMimeType;
        this.outputCompressionQuality = outputCompressionQuality;
    }

    @Override
    @JsonProperty(value="aspectRatio")
    public Optional<String> aspectRatio() {
        return this.aspectRatio;
    }

    @Override
    @JsonProperty(value="imageSize")
    public Optional<String> imageSize() {
        return this.imageSize;
    }

    @Override
    @JsonProperty(value="outputMimeType")
    public Optional<String> outputMimeType() {
        return this.outputMimeType;
    }

    @Override
    @JsonProperty(value="outputCompressionQuality")
    public Optional<Integer> outputCompressionQuality() {
        return this.outputCompressionQuality;
    }

    public String toString() {
        return "ImageConfig{aspectRatio=" + this.aspectRatio + ", imageSize=" + this.imageSize + ", outputMimeType=" + this.outputMimeType + ", outputCompressionQuality=" + this.outputCompressionQuality + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageConfig) {
            ImageConfig that = (ImageConfig)o;
            return this.aspectRatio.equals(that.aspectRatio()) && this.imageSize.equals(that.imageSize()) && this.outputMimeType.equals(that.outputMimeType()) && this.outputCompressionQuality.equals(that.outputCompressionQuality());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.aspectRatio.hashCode();
        h$ *= 1000003;
        h$ ^= this.imageSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputMimeType.hashCode();
        h$ *= 1000003;
        return h$ ^= this.outputCompressionQuality.hashCode();
    }

    @Override
    public ImageConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ImageConfig.Builder {
        private Optional<String> aspectRatio = Optional.empty();
        private Optional<String> imageSize = Optional.empty();
        private Optional<String> outputMimeType = Optional.empty();
        private Optional<Integer> outputCompressionQuality = Optional.empty();

        Builder() {
        }

        Builder(ImageConfig source) {
            this.aspectRatio = source.aspectRatio();
            this.imageSize = source.imageSize();
            this.outputMimeType = source.outputMimeType();
            this.outputCompressionQuality = source.outputCompressionQuality();
        }

        @Override
        public ImageConfig.Builder aspectRatio(String aspectRatio) {
            this.aspectRatio = Optional.of(aspectRatio);
            return this;
        }

        @Override
        ImageConfig.Builder aspectRatio(Optional<String> aspectRatio) {
            if (aspectRatio == null) {
                throw new NullPointerException("Null aspectRatio");
            }
            this.aspectRatio = aspectRatio;
            return this;
        }

        @Override
        public ImageConfig.Builder imageSize(String imageSize) {
            this.imageSize = Optional.of(imageSize);
            return this;
        }

        @Override
        ImageConfig.Builder imageSize(Optional<String> imageSize) {
            if (imageSize == null) {
                throw new NullPointerException("Null imageSize");
            }
            this.imageSize = imageSize;
            return this;
        }

        @Override
        public ImageConfig.Builder outputMimeType(String outputMimeType) {
            this.outputMimeType = Optional.of(outputMimeType);
            return this;
        }

        @Override
        ImageConfig.Builder outputMimeType(Optional<String> outputMimeType) {
            if (outputMimeType == null) {
                throw new NullPointerException("Null outputMimeType");
            }
            this.outputMimeType = outputMimeType;
            return this;
        }

        @Override
        public ImageConfig.Builder outputCompressionQuality(Integer outputCompressionQuality) {
            this.outputCompressionQuality = Optional.of(outputCompressionQuality);
            return this;
        }

        @Override
        ImageConfig.Builder outputCompressionQuality(Optional<Integer> outputCompressionQuality) {
            if (outputCompressionQuality == null) {
                throw new NullPointerException("Null outputCompressionQuality");
            }
            this.outputCompressionQuality = outputCompressionQuality;
            return this;
        }

        @Override
        public ImageConfig build() {
            return new AutoValue_ImageConfig(this.aspectRatio, this.imageSize, this.outputMimeType, this.outputCompressionQuality);
        }
    }
}

