/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.CreateTuningJobConfig;
import com.google.genai.types.CreateTuningJobParameters;
import com.google.genai.types.TuningDataset;
import java.util.Optional;

final class AutoValue_CreateTuningJobParameters
extends CreateTuningJobParameters {
    private final Optional<String> baseModel;
    private final Optional<TuningDataset> trainingDataset;
    private final Optional<CreateTuningJobConfig> config;

    private AutoValue_CreateTuningJobParameters(Optional<String> baseModel, Optional<TuningDataset> trainingDataset, Optional<CreateTuningJobConfig> config) {
        this.baseModel = baseModel;
        this.trainingDataset = trainingDataset;
        this.config = config;
    }

    @Override
    @JsonProperty(value="baseModel")
    public Optional<String> baseModel() {
        return this.baseModel;
    }

    @Override
    @JsonProperty(value="trainingDataset")
    public Optional<TuningDataset> trainingDataset() {
        return this.trainingDataset;
    }

    @Override
    @JsonProperty(value="config")
    public Optional<CreateTuningJobConfig> config() {
        return this.config;
    }

    public String toString() {
        return "CreateTuningJobParameters{baseModel=" + this.baseModel + ", trainingDataset=" + this.trainingDataset + ", config=" + this.config + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CreateTuningJobParameters) {
            CreateTuningJobParameters that = (CreateTuningJobParameters)o;
            return this.baseModel.equals(that.baseModel()) && this.trainingDataset.equals(that.trainingDataset()) && this.config.equals(that.config());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.baseModel.hashCode();
        h$ *= 1000003;
        h$ ^= this.trainingDataset.hashCode();
        h$ *= 1000003;
        return h$ ^= this.config.hashCode();
    }

    @Override
    public CreateTuningJobParameters.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CreateTuningJobParameters.Builder {
        private Optional<String> baseModel = Optional.empty();
        private Optional<TuningDataset> trainingDataset = Optional.empty();
        private Optional<CreateTuningJobConfig> config = Optional.empty();

        Builder() {
        }

        Builder(CreateTuningJobParameters source) {
            this.baseModel = source.baseModel();
            this.trainingDataset = source.trainingDataset();
            this.config = source.config();
        }

        @Override
        public CreateTuningJobParameters.Builder baseModel(String baseModel) {
            this.baseModel = Optional.of(baseModel);
            return this;
        }

        @Override
        CreateTuningJobParameters.Builder baseModel(Optional<String> baseModel) {
            if (baseModel == null) {
                throw new NullPointerException("Null baseModel");
            }
            this.baseModel = baseModel;
            return this;
        }

        @Override
        public CreateTuningJobParameters.Builder trainingDataset(TuningDataset trainingDataset) {
            this.trainingDataset = Optional.of(trainingDataset);
            return this;
        }

        @Override
        CreateTuningJobParameters.Builder trainingDataset(Optional<TuningDataset> trainingDataset) {
            if (trainingDataset == null) {
                throw new NullPointerException("Null trainingDataset");
            }
            this.trainingDataset = trainingDataset;
            return this;
        }

        @Override
        public CreateTuningJobParameters.Builder config(CreateTuningJobConfig config) {
            this.config = Optional.of(config);
            return this;
        }

        @Override
        CreateTuningJobParameters.Builder config(Optional<CreateTuningJobConfig> config) {
            if (config == null) {
                throw new NullPointerException("Null config");
            }
            this.config = config;
            return this;
        }

        @Override
        public CreateTuningJobParameters build() {
            return new AutoValue_CreateTuningJobParameters(this.baseModel, this.trainingDataset, this.config);
        }
    }
}

