/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.common.collect.ImmutableMap;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.HttpOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.ResponseBody;

final class UploadClient {
    private final ApiClient apiClient;
    private final int chunkSize;
    public static final int DEFAULT_CHUNK_SIZE = 0x800000;
    public static final int MAX_RETRY_COUNT = 3;
    public static final Duration INITIAL_RETRY_DELAY = Duration.ofSeconds(1L);
    public static final int DELAY_MULTIPLIER = 2;

    public UploadClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.chunkSize = 0x800000;
    }

    public UploadClient(ApiClient apiClient, int chunkSize) {
        this.apiClient = apiClient;
        this.chunkSize = chunkSize;
    }

    public static HttpOptions buildResumableUploadHttpOptions(Optional<HttpOptions> userOptions, Optional<String> mimeType, Optional<String> fileName, long size) {
        String actualMimeType = mimeType.orElseThrow(() -> new IllegalArgumentException("Unknown mime type: Could not determine mime type for your file, please set the mimeType config argument"));
        HttpOptions.Builder httpOptionsBuilder = HttpOptions.builder();
        if (userOptions.isPresent()) {
            httpOptionsBuilder = userOptions.get().toBuilder();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("X-Goog-Upload-Protocol", "resumable");
        headers.put("X-Goog-Upload-Command", "start");
        headers.put("X-Goog-Upload-Header-Content-Length", "" + size);
        headers.put("X-Goog-Upload-Header-Content-Type", actualMimeType);
        if (fileName.isPresent()) {
            headers.put("X-Goog-Upload-File-Name", fileName.get());
        }
        return httpOptionsBuilder.apiVersion("").headers(headers).build();
    }

    public ResponseBody upload(String uploadUrl, String filePath) {
        ResponseBody responseBody;
        File file = new File(filePath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            responseBody = this.upload(uploadUrl, inputStream, file.length());
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to process input stream", e);
        }
        return responseBody;
    }

    public ResponseBody upload(String uploadUrl, byte[] bytes) {
        ResponseBody responseBody;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            responseBody = this.upload(uploadUrl, inputStream, bytes.length);
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to process input stream", e);
        }
        return responseBody;
    }

    public ResponseBody upload(String uploadUrl, InputStream inputStream, long size) {
        String uploadStatus;
        UploadChunkResponse uploadChunkResponse;
        int bytesRead;
        String uploadCommand = "upload";
        byte[] buffer = new byte[this.chunkSize];
        int offset = 0;
        try {
            while ((bytesRead = inputStream.read(buffer, 0, this.chunkSize)) == this.chunkSize) {
                uploadChunkResponse = this.uploadChunk(uploadUrl, buffer, offset, uploadCommand);
                uploadStatus = uploadChunkResponse.getUploadStatus();
                offset += bytesRead;
                if (uploadStatus != null && uploadStatus.equals("active")) continue;
                throw new IllegalStateException("Unexpected upload status: " + uploadStatus + " please try again.");
            }
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to process input stream", e);
        }
        buffer = Arrays.copyOfRange(buffer, 0, bytesRead);
        uploadCommand = uploadCommand + ", finalize";
        uploadChunkResponse = this.uploadChunk(uploadUrl, buffer, offset, uploadCommand);
        uploadStatus = uploadChunkResponse.getUploadStatus();
        if (uploadStatus == null || !uploadStatus.equals("final")) {
            throw new IllegalStateException("Unexpected final upload status: " + uploadStatus + " please try again.");
        }
        return uploadChunkResponse.getEntity();
    }

    private UploadChunkResponse uploadChunk(String uploadUrl, byte[] chunk, long offset, String uploadCommand) {
        HttpOptions httpOptions = HttpOptions.builder().headers((Map<String, String>)ImmutableMap.of((Object)"X-Goog-Upload-Command", (Object)uploadCommand, (Object)"X-Goog-Upload-Offset", (Object)Long.toString(offset))).build();
        boolean uploadStatusHeaderFound = false;
        String uploadStatus = "";
        ApiResponse response = null;
        for (int retryCount = 0; retryCount < 3; ++retryCount) {
            String headerValue;
            response = this.apiClient.request("POST", uploadUrl, chunk, Optional.of(httpOptions));
            Headers headers = response.getHeaders();
            if (headers != null && (headerValue = headers.get("X-Goog-Upload-Status")) != null) {
                uploadStatusHeaderFound = true;
                uploadStatus = headerValue;
                break;
            }
            if (uploadStatusHeaderFound) break;
            Duration delay = INITIAL_RETRY_DELAY.multipliedBy((long)Math.pow(2.0, retryCount));
            try {
                Thread.sleep(delay.toMillis());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while sleeping", e);
            }
        }
        if (!uploadStatusHeaderFound) {
            throw new IllegalStateException("Upload failed. Retries exhausted, please try again.");
        }
        return new UploadChunkResponse(uploadStatus, response.getBody());
    }

    private static class UploadChunkResponse {
        private final String uploadStatus;
        private final ResponseBody entity;

        UploadChunkResponse(String uploadStatus, ResponseBody entity) {
            this.uploadStatus = uploadStatus;
            this.entity = entity;
        }

        public String getUploadStatus() {
            return this.uploadStatus;
        }

        public ResponseBody getEntity() {
            return this.entity;
        }
    }
}

