/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Ascii;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.Documents;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Pager;
import com.google.genai.UploadClient;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.CreateFileSearchStoreConfig;
import com.google.genai.types.CreateFileSearchStoreParameters;
import com.google.genai.types.DeleteFileSearchStoreConfig;
import com.google.genai.types.DeleteFileSearchStoreParameters;
import com.google.genai.types.FileSearchStore;
import com.google.genai.types.GetFileSearchStoreConfig;
import com.google.genai.types.GetFileSearchStoreParameters;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.HttpResponse;
import com.google.genai.types.ImportFileConfig;
import com.google.genai.types.ImportFileOperation;
import com.google.genai.types.ImportFileParameters;
import com.google.genai.types.ListFileSearchStoresConfig;
import com.google.genai.types.ListFileSearchStoresParameters;
import com.google.genai.types.ListFileSearchStoresResponse;
import com.google.genai.types.UploadToFileSearchStoreConfig;
import com.google.genai.types.UploadToFileSearchStoreOperation;
import com.google.genai.types.UploadToFileSearchStoreParameters;
import com.google.genai.types.UploadToFileSearchStoreResumableResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.Headers;
import okhttp3.ResponseBody;

public final class FileSearchStores {
    public final Documents documents;
    final ApiClient apiClient;
    private final UploadClient uploadClient;

    public FileSearchStores(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.uploadClient = new UploadClient(apiClient);
        this.documents = new Documents(apiClient);
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createFileSearchStoreConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createFileSearchStoreParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.createFileSearchStoreConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteFileSearchStoreConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"force"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "force"}, Common.getValueByPath(fromObject, new String[]{"force"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteFileSearchStoreParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.deleteFileSearchStoreConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getFileSearchStoreParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode importFileConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"customMetadata"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"customMetadata"}, Common.getValueByPath(fromObject, new String[]{"customMetadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"chunkingConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"chunkingConfig"}, Common.getValueByPath(fromObject, new String[]{"chunkingConfig"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode importFileOperationFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.importFileResponseFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode importFileParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fileSearchStoreName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "file_search_store_name"}, Common.getValueByPath(fromObject, new String[]{"fileSearchStoreName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileName"}, Common.getValueByPath(fromObject, new String[]{"fileName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.importFileConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode importFileResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parent"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parent"}, Common.getValueByPath(fromObject, new String[]{"parent"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"documentName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"documentName"}, Common.getValueByPath(fromObject, new String[]{"documentName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listFileSearchStoresConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listFileSearchStoresParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.listFileSearchStoresConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listFileSearchStoresResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileSearchStores"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileSearchStores"}, Common.getValueByPath(fromObject, new String[]{"fileSearchStores"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode uploadToFileSearchStoreConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"customMetadata"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"customMetadata"}, Common.getValueByPath(fromObject, new String[]{"customMetadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"chunkingConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"chunkingConfig"}, Common.getValueByPath(fromObject, new String[]{"chunkingConfig"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode uploadToFileSearchStoreParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fileSearchStoreName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "file_search_store_name"}, Common.getValueByPath(fromObject, new String[]{"fileSearchStoreName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.uploadToFileSearchStoreConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode uploadToFileSearchStoreResumableResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        return toObject;
    }

    Common.BuiltRequest buildRequestForCreate(CreateFileSearchStoreConfig config) {
        CreateFileSearchStoreParameters.Builder parameterBuilder = CreateFileSearchStoreParameters.builder();
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.createFileSearchStoreParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("fileSearchStores", body.get("_url")) : "fileSearchStores";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    FileSearchStore processResponseForCreate(ApiResponse response, CreateFileSearchStoreConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        return JsonSerializable.fromJsonNode(responseNode, FileSearchStore.class);
    }

    public FileSearchStore create(CreateFileSearchStoreConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForCreate(config);
        try (ApiResponse response = this.apiClient.request("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            FileSearchStore fileSearchStore = this.processResponseForCreate(response, config);
            return fileSearchStore;
        }
    }

    Common.BuiltRequest buildRequestForGet(String name, GetFileSearchStoreConfig config) {
        GetFileSearchStoreParameters.Builder parameterBuilder = GetFileSearchStoreParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.getFileSearchStoreParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    FileSearchStore processResponseForGet(ApiResponse response, GetFileSearchStoreConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        return JsonSerializable.fromJsonNode(responseNode, FileSearchStore.class);
    }

    public FileSearchStore get(String name, GetFileSearchStoreConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForGet(name, config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            FileSearchStore fileSearchStore = this.processResponseForGet(response, config);
            return fileSearchStore;
        }
    }

    Common.BuiltRequest buildRequestForDelete(String name, DeleteFileSearchStoreConfig config) {
        DeleteFileSearchStoreParameters.Builder parameterBuilder = DeleteFileSearchStoreParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.deleteFileSearchStoreParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    public void delete(String name, DeleteFileSearchStoreConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForDelete(name, config);
        ApiResponse response = this.apiClient.request("delete", builtRequest.path, builtRequest.body, builtRequest.httpOptions);
        if (response != null) {
            response.close();
        }
    }

    Common.BuiltRequest buildRequestForPrivateList(ListFileSearchStoresConfig config) {
        ListFileSearchStoresParameters.Builder parameterBuilder = ListFileSearchStoresParameters.builder();
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.listFileSearchStoresParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("fileSearchStores", body.get("_url")) : "fileSearchStores";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    ListFileSearchStoresResponse processResponseForPrivateList(ApiResponse response, ListFileSearchStoresConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.listFileSearchStoresResponseFromMldev(responseNode, null);
        }
        return JsonSerializable.fromJsonNode(responseNode, ListFileSearchStoresResponse.class);
    }

    ListFileSearchStoresResponse privateList(ListFileSearchStoresConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateList(config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            ListFileSearchStoresResponse listFileSearchStoresResponse = this.processResponseForPrivateList(response, config);
            return listFileSearchStoresResponse;
        }
    }

    Common.BuiltRequest buildRequestForPrivateUploadToFileSearchStore(String fileSearchStoreName, UploadToFileSearchStoreConfig config) {
        UploadToFileSearchStoreParameters.Builder parameterBuilder = UploadToFileSearchStoreParameters.builder();
        if (!Common.isZero(fileSearchStoreName)) {
            parameterBuilder.fileSearchStoreName(fileSearchStoreName);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.uploadToFileSearchStoreParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("upload/v1beta/{file_search_store_name}:uploadToFileSearchStore", body.get("_url")) : "upload/v1beta/{file_search_store_name}:uploadToFileSearchStore";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    UploadToFileSearchStoreResumableResponse processResponseForPrivateUploadToFileSearchStore(ApiResponse response, UploadToFileSearchStoreConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        if (config != null && config.shouldReturnHttpResponse().orElse(false).booleanValue()) {
            Headers responseHeaders = response.getHeaders();
            if (responseHeaders == null) {
                return UploadToFileSearchStoreResumableResponse.builder().sdkHttpResponse(HttpResponse.builder().body(responseString)).build();
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            for (String headerName : responseHeaders.names()) {
                headers.put(headerName, responseHeaders.get(headerName));
            }
            return UploadToFileSearchStoreResumableResponse.builder().sdkHttpResponse(HttpResponse.builder().headers(headers).body(responseString)).build();
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.uploadToFileSearchStoreResumableResponseFromMldev(responseNode, null);
        }
        return JsonSerializable.fromJsonNode(responseNode, UploadToFileSearchStoreResumableResponse.class);
    }

    UploadToFileSearchStoreResumableResponse privateUploadToFileSearchStore(String fileSearchStoreName, UploadToFileSearchStoreConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateUploadToFileSearchStore(fileSearchStoreName, config);
        try (ApiResponse response = this.apiClient.request("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            UploadToFileSearchStoreResumableResponse uploadToFileSearchStoreResumableResponse = this.processResponseForPrivateUploadToFileSearchStore(response, config);
            return uploadToFileSearchStoreResumableResponse;
        }
    }

    Common.BuiltRequest buildRequestForImportFile(String fileSearchStoreName, String fileName, ImportFileConfig config) {
        ImportFileParameters.Builder parameterBuilder = ImportFileParameters.builder();
        if (!Common.isZero(fileSearchStoreName)) {
            parameterBuilder.fileSearchStoreName(fileSearchStoreName);
        }
        if (!Common.isZero(fileName)) {
            parameterBuilder.fileName(fileName);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.importFileParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("{file_search_store_name}:importFile", body.get("_url")) : "{file_search_store_name}:importFile";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    ImportFileOperation processResponseForImportFile(ApiResponse response, ImportFileConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.importFileOperationFromMldev(responseNode, null);
        }
        return JsonSerializable.fromJsonNode(responseNode, ImportFileOperation.class);
    }

    public ImportFileOperation importFile(String fileSearchStoreName, String fileName, ImportFileConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForImportFile(fileSearchStoreName, fileName, config);
        try (ApiResponse response = this.apiClient.request("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            ImportFileOperation importFileOperation = this.processResponseForImportFile(response, config);
            return importFileOperation;
        }
    }

    public Pager<FileSearchStore> list(ListFileSearchStoresConfig config) {
        if (config == null) {
            config = ListFileSearchStoresConfig.builder().build();
        }
        Function<JsonSerializable, Object> request = requestConfig -> {
            if (!(requestConfig instanceof ListFileSearchStoresConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListFileSearchStoresConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListFileSearchStoresConfig)requestConfig);
        };
        return new Pager<FileSearchStore>(BasePager.PagedItem.FILE_SEARCH_STORES, request, (ObjectNode)JsonSerializable.toJsonNode(config), JsonSerializable.toJsonNode(this.privateList(config)));
    }

    static UploadToFileSearchStoreOperation operationFromResponse(ResponseBody responseBody) {
        String responseString;
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        return JsonSerializable.fromJsonNode(responseNode, UploadToFileSearchStoreOperation.class);
    }

    private String getUploadUrl(String fileSearchStoreName, UploadToFileSearchStoreConfig config, Optional<String> mimeType, Optional<String> fileName, long size) {
        Optional<String> mimeTypeToUse = mimeType.isPresent() ? mimeType : Optional.ofNullable(config).flatMap(UploadToFileSearchStoreConfig::mimeType);
        Optional<HttpOptions> userHttpOptions = Optional.ofNullable(config).flatMap(UploadToFileSearchStoreConfig::httpOptions);
        HttpOptions httpOptions = UploadClient.buildResumableUploadHttpOptions(userHttpOptions, mimeTypeToUse, fileName, size);
        UploadToFileSearchStoreResumableResponse response = this.privateUploadToFileSearchStore(fileSearchStoreName, UploadToFileSearchStoreConfig.builder().httpOptions(httpOptions).shouldReturnHttpResponse(true).build());
        return (String)response.sdkHttpResponse().flatMap(HttpResponse::headers).flatMap(headers -> headers.entrySet().stream().filter(entry -> Ascii.equalsIgnoreCase((CharSequence)"x-goog-upload-url", (CharSequence)((CharSequence)entry.getKey()))).map(entry -> (String)entry.getValue()).findFirst()).orElseThrow(() -> new IllegalStateException("Failed to upload to file search store. Upload URL was not returned in the resumable response."));
    }

    public UploadToFileSearchStoreOperation uploadToFileSearchStore(String fileSearchStoreName, File file, UploadToFileSearchStoreConfig config) {
        UploadToFileSearchStoreOperation uploadToFileSearchStoreOperation;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            long size = file.length();
            String fileName = file.getName();
            String probedMimeType = Files.probeContentType(file.toPath());
            Optional<String> mimeType = probedMimeType != null ? Optional.of(probedMimeType) : Optional.empty();
            String uploadUrl = this.getUploadUrl(fileSearchStoreName, config, mimeType, Optional.of(fileName), size);
            ResponseBody responseBody = this.uploadClient.upload(uploadUrl, inputStream, size);
            uploadToFileSearchStoreOperation = FileSearchStores.operationFromResponse(responseBody);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to upload file.", e);
            }
        }
        ((InputStream)inputStream).close();
        return uploadToFileSearchStoreOperation;
    }

    public UploadToFileSearchStoreOperation uploadToFileSearchStore(String fileSearchStoreName, byte[] bytes, UploadToFileSearchStoreConfig config) {
        String uploadUrl = this.getUploadUrl(fileSearchStoreName, config, Optional.empty(), Optional.empty(), bytes.length);
        ResponseBody responseBody = this.uploadClient.upload(uploadUrl, bytes);
        return FileSearchStores.operationFromResponse(responseBody);
    }

    public UploadToFileSearchStoreOperation uploadToFileSearchStore(String fileSearchStoreName, InputStream inputStream, long size, UploadToFileSearchStoreConfig config) {
        String uploadUrl = this.getUploadUrl(fileSearchStoreName, config, Optional.empty(), Optional.empty(), size);
        ResponseBody responseBody = this.uploadClient.upload(uploadUrl, inputStream, size);
        return FileSearchStores.operationFromResponse(responseBody);
    }

    public UploadToFileSearchStoreOperation uploadToFileSearchStore(String fileSearchStoreName, String filePath, UploadToFileSearchStoreConfig config) {
        File file = new File(filePath);
        return this.uploadToFileSearchStore(fileSearchStoreName, file, config);
    }
}

