/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Pager;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.DeleteDocumentConfig;
import com.google.genai.types.DeleteDocumentParameters;
import com.google.genai.types.Document;
import com.google.genai.types.GetDocumentConfig;
import com.google.genai.types.GetDocumentParameters;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.ListDocumentsConfig;
import com.google.genai.types.ListDocumentsParameters;
import com.google.genai.types.ListDocumentsResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.ResponseBody;

public final class Documents {
    final ApiClient apiClient;

    public Documents(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteDocumentConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"force"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "force"}, Common.getValueByPath(fromObject, new String[]{"force"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteDocumentParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.deleteDocumentConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getDocumentParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listDocumentsConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listDocumentsParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parent"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "parent"}, Common.getValueByPath(fromObject, new String[]{"parent"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.listDocumentsConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listDocumentsResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"documents"}) != null) {
            Common.setValueByPath(toObject, new String[]{"documents"}, Common.getValueByPath(fromObject, new String[]{"documents"}));
        }
        return toObject;
    }

    Common.BuiltRequest buildRequestForGet(String name, GetDocumentConfig config) {
        GetDocumentParameters.Builder parameterBuilder = GetDocumentParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.getDocumentParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    Document processResponseForGet(ApiResponse response, GetDocumentConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        return JsonSerializable.fromJsonNode(responseNode, Document.class);
    }

    public Document get(String name, GetDocumentConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForGet(name, config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            Document document = this.processResponseForGet(response, config);
            return document;
        }
    }

    Common.BuiltRequest buildRequestForDelete(String name, DeleteDocumentConfig config) {
        DeleteDocumentParameters.Builder parameterBuilder = DeleteDocumentParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.deleteDocumentParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    public void delete(String name, DeleteDocumentConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForDelete(name, config);
        ApiResponse response = this.apiClient.request("delete", builtRequest.path, builtRequest.body, builtRequest.httpOptions);
        if (response != null) {
            response.close();
        }
    }

    Common.BuiltRequest buildRequestForPrivateList(String parent, ListDocumentsConfig config) {
        ListDocumentsParameters.Builder parameterBuilder = ListDocumentsParameters.builder();
        if (!Common.isZero(parent)) {
            parameterBuilder.parent(parent);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.listDocumentsParametersToMldev(parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("{parent}/documents", body.get("_url")) : "{parent}/documents";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    ListDocumentsResponse processResponseForPrivateList(ApiResponse response, ListDocumentsConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.listDocumentsResponseFromMldev(responseNode, null);
        }
        return JsonSerializable.fromJsonNode(responseNode, ListDocumentsResponse.class);
    }

    ListDocumentsResponse privateList(String parent, ListDocumentsConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateList(parent, config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            ListDocumentsResponse listDocumentsResponse = this.processResponseForPrivateList(response, config);
            return listDocumentsResponse;
        }
    }

    public Pager<Document> list(String parent, ListDocumentsConfig config) {
        if (config == null) {
            config = ListDocumentsConfig.builder().build();
        }
        Function<JsonSerializable, Object> request = requestConfig -> {
            if (!(requestConfig instanceof ListDocumentsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListDocumentsConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList(parent, (ListDocumentsConfig)requestConfig);
        };
        return new Pager<Document>(BasePager.PagedItem.DOCUMENTS, request, (ObjectNode)JsonSerializable.toJsonNode(config), JsonSerializable.toJsonNode(this.privateList(parent, config)));
    }
}

