/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.Common;
import com.google.genai.Operations;
import com.google.genai.types.FetchPredictOperationConfig;
import com.google.genai.types.GenerateVideosOperation;
import com.google.genai.types.GetOperationConfig;
import com.google.genai.types.Operation;
import java.util.concurrent.CompletableFuture;

public final class AsyncOperations {
    Operations operations;
    ApiClient apiClient;

    public AsyncOperations(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.operations = new Operations(apiClient);
    }

    CompletableFuture<JsonNode> privateGetVideosOperation(String operationName, GetOperationConfig config) {
        Common.BuiltRequest builtRequest = this.operations.buildRequestForPrivateGetVideosOperation(operationName, config);
        return this.apiClient.asyncRequest("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                JsonNode jsonNode = this.operations.processResponseForPrivateGetVideosOperation(res, config);
                return jsonNode;
            }
        });
    }

    CompletableFuture<JsonNode> privateFetchPredictVideosOperation(String operationName, String resourceName, FetchPredictOperationConfig config) {
        Common.BuiltRequest builtRequest = this.operations.buildRequestForPrivateFetchPredictVideosOperation(operationName, resourceName, config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                JsonNode jsonNode = this.operations.processResponseForPrivateFetchPredictVideosOperation(res, config);
                return jsonNode;
            }
        });
    }

    public CompletableFuture<GenerateVideosOperation> getVideosOperation(GenerateVideosOperation operation, GetOperationConfig config) {
        return this.get(operation, config);
    }

    public <T, U extends Operation<T, U>> CompletableFuture<U> get(U operation, GetOperationConfig config) {
        if (!operation.name().isPresent()) {
            throw new IllegalArgumentException("Operation name is required.");
        }
        if (this.apiClient.vertexAI()) {
            String resourceName = operation.name().get().split("/operations/")[0];
            return this.privateFetchPredictVideosOperation(operation.name().get(), resourceName, null).thenApplyAsync(response -> operation.fromApiResponse((JsonNode)response, true));
        }
        return this.privateGetVideosOperation(operation.name().get(), config).thenApplyAsync(response -> operation.fromApiResponse((JsonNode)response, false));
    }
}

