/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.Batches;
import com.google.genai.Common;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.BatchJob;
import com.google.genai.types.BatchJobSource;
import com.google.genai.types.CancelBatchJobConfig;
import com.google.genai.types.CreateBatchJobConfig;
import com.google.genai.types.CreateEmbeddingsBatchJobConfig;
import com.google.genai.types.DeleteBatchJobConfig;
import com.google.genai.types.DeleteResourceJob;
import com.google.genai.types.EmbeddingsBatchJobSource;
import com.google.genai.types.GetBatchJobConfig;
import com.google.genai.types.ListBatchJobsConfig;
import com.google.genai.types.ListBatchJobsResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncBatches {
    Batches batches;
    ApiClient apiClient;

    public AsyncBatches(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.batches = new Batches(apiClient);
    }

    CompletableFuture<BatchJob> privateCreate(String model, BatchJobSource src, CreateBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.batches.buildRequestForPrivateCreate(model, src, config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                BatchJob batchJob = this.batches.processResponseForPrivateCreate(res, config);
                return batchJob;
            }
        });
    }

    CompletableFuture<BatchJob> privateCreateEmbeddings(String model, EmbeddingsBatchJobSource src, CreateEmbeddingsBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.batches.buildRequestForPrivateCreateEmbeddings(model, src, config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                BatchJob batchJob = this.batches.processResponseForPrivateCreateEmbeddings(res, config);
                return batchJob;
            }
        });
    }

    public CompletableFuture<BatchJob> get(String name, GetBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.batches.buildRequestForGet(name, config);
        return this.apiClient.asyncRequest("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                BatchJob batchJob = this.batches.processResponseForGet(res, config);
                return batchJob;
            }
        });
    }

    public CompletableFuture<Void> cancel(String name, CancelBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.batches.buildRequestForCancel(name, config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenAccept(response -> {
            ApiResponse res = response;
            if (res != null) {
                res.close();
            }
        });
    }

    CompletableFuture<ListBatchJobsResponse> privateList(ListBatchJobsConfig config) {
        Common.BuiltRequest builtRequest = this.batches.buildRequestForPrivateList(config);
        return this.apiClient.asyncRequest("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                ListBatchJobsResponse listBatchJobsResponse = this.batches.processResponseForPrivateList(res, config);
                return listBatchJobsResponse;
            }
        });
    }

    public CompletableFuture<DeleteResourceJob> delete(String name, DeleteBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.batches.buildRequestForDelete(name, config);
        return this.apiClient.asyncRequest("delete", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                DeleteResourceJob deleteResourceJob = this.batches.processResponseForDelete(res, config);
                return deleteResourceJob;
            }
        });
    }

    public CompletableFuture<BatchJob> create(String model, BatchJobSource src, CreateBatchJobConfig config) {
        if (this.apiClient.vertexAI()) {
            if (src.inlinedRequests().isPresent()) {
                throw new GenAiIOException("inlinedRequests is not supported for Vertex AI.");
            }
            if (src.fileName().isPresent()) {
                throw new GenAiIOException("fileName is not supported for Vertex AI.");
            }
            if (src.gcsUri().isPresent() && src.bigqueryUri().isPresent()) {
                throw new GenAiIOException("Only one of gcsUri and bigqueryUri can be set.");
            }
            if (!src.gcsUri().isPresent() && !src.bigqueryUri().isPresent()) {
                throw new GenAiIOException("One of gcsUri and bigqueryUri must be set.");
            }
        } else {
            if (src.fileName().isPresent() && src.inlinedRequests().isPresent()) {
                throw new GenAiIOException("Only one of fileName and InlinedRequests can be set.");
            }
            if (!src.fileName().isPresent() && !src.inlinedRequests().isPresent()) {
                throw new GenAiIOException("one of fileName and InlinedRequests must be set.");
            }
        }
        return this.privateCreate(model, src, config);
    }

    public CompletableFuture<BatchJob> createEmbeddings(String model, EmbeddingsBatchJobSource src, CreateEmbeddingsBatchJobConfig config) {
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("Vertex AI does not support batches.createEmbeddings.");
        }
        return this.privateCreateEmbeddings(model, src, config);
    }

    public CompletableFuture<AsyncPager<BatchJob>> list(ListBatchJobsConfig config) {
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListBatchJobsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListBatchJobsConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListBatchJobsConfig)requestConfig).thenApply(JsonSerializable::toJsonNode);
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.BATCH_JOBS, request, (ObjectNode)JsonSerializable.toJsonNode(config), (CompletableFuture)request.apply(config)));
    }
}

