/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

public class SimpleJavaFileObject
implements JavaFileObject {
    protected final URI uri;
    protected final JavaFileObject.Kind kind;

    protected SimpleJavaFileObject(URI uri, JavaFileObject.Kind kind) {
        uri.getClass();
        ((Object)((Object)kind)).getClass();
        if (uri.getPath() == null) {
            String string = String.valueOf(String.valueOf(uri));
            throw new IllegalArgumentException(new StringBuilder(22 + string.length()).append("URI must have a path: ").append(string).toString());
        }
        this.uri = uri;
        this.kind = kind;
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public String getName() {
        return this.toUri().getPath();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        CharBuffer buffer;
        CharSequence charContent = this.getCharContent(ignoreEncodingErrors);
        if (charContent == null) {
            throw new UnsupportedOperationException();
        }
        if (charContent instanceof CharBuffer && (buffer = (CharBuffer)charContent).hasArray()) {
            return new CharArrayReader(buffer.array());
        }
        return new StringReader(charContent.toString());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream());
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        String string = String.valueOf(simpleName);
        String string2 = String.valueOf(kind.extension);
        String baseName = string2.length() != 0 ? string.concat(string2) : new String(string);
        if (!kind.equals((Object)this.getKind())) return false;
        if (baseName.equals(this.toUri().getPath())) return true;
        String string3 = String.valueOf(baseName);
        if (!this.toUri().getPath().endsWith(string3.length() != 0 ? "/".concat(string3) : new String("/"))) return false;
        return true;
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.getClass().getName()));
        String string2 = String.valueOf(String.valueOf(this.toUri()));
        return new StringBuilder(2 + string.length() + string2.length()).append(string).append("[").append(string2).append("]").toString();
    }
}

