/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class LVTRanges {
    protected static final Context.Key<LVTRanges> lvtRangesKey = new Context.Key();
    private static final long serialVersionUID = 1812267524140424433L;
    protected Context context;
    protected Map<Symbol.MethodSymbol, Map<JCTree, List<Symbol.VarSymbol>>> aliveRangeClosingTrees = new WeakHashMap<Symbol.MethodSymbol, Map<JCTree, List<Symbol.VarSymbol>>>();

    public static LVTRanges instance(Context context) {
        LVTRanges instance = context.get(lvtRangesKey);
        if (instance == null) {
            instance = new LVTRanges(context);
        }
        return instance;
    }

    public LVTRanges(Context context) {
        this.context = context;
        context.put(lvtRangesKey, this);
    }

    public List<Symbol.VarSymbol> getVars(Symbol.MethodSymbol method, JCTree tree) {
        Map<JCTree, List<Symbol.VarSymbol>> varMap = this.aliveRangeClosingTrees.get(method);
        return varMap != null ? varMap.get(tree) : null;
    }

    public boolean containsKey(Symbol.MethodSymbol method, JCTree tree) {
        Map<JCTree, List<Symbol.VarSymbol>> varMap = this.aliveRangeClosingTrees.get(method);
        if (varMap == null) {
            return false;
        }
        return varMap.containsKey(tree);
    }

    public void setEntry(Symbol.MethodSymbol method, JCTree tree, List<Symbol.VarSymbol> vars) {
        Map<JCTree, List<Symbol.VarSymbol>> varMap = this.aliveRangeClosingTrees.get(method);
        if (varMap != null) {
            varMap.put(tree, vars);
        } else {
            varMap = new WeakHashMap<JCTree, List<Symbol.VarSymbol>>();
            varMap.put(tree, vars);
            this.aliveRangeClosingTrees.put(method, varMap);
        }
    }

    public List<Symbol.VarSymbol> removeEntry(Symbol.MethodSymbol method, JCTree tree) {
        Map<JCTree, List<Symbol.VarSymbol>> varMap = this.aliveRangeClosingTrees.get(method);
        if (varMap != null) {
            List<Symbol.VarSymbol> result = varMap.remove(tree);
            if (varMap.isEmpty()) {
                this.aliveRangeClosingTrees.remove(method);
            }
            return result;
        }
        return null;
    }

    public String toString() {
        String result = "";
        for (Map.Entry<Symbol.MethodSymbol, Map<JCTree, List<Symbol.VarSymbol>>> mainEntry : this.aliveRangeClosingTrees.entrySet()) {
            String string = String.valueOf(result);
            String string2 = String.valueOf(String.valueOf(mainEntry.getKey().flatName()));
            result = new StringBuilder(10 + string.length() + string2.length()).append(string).append("Method: \n").append(string2).append("\n").toString();
            int i = 1;
            for (Map.Entry<JCTree, List<Symbol.VarSymbol>> treeEntry : mainEntry.getValue().entrySet()) {
                String string3 = String.valueOf(result);
                int n = i;
                String string4 = String.valueOf(String.valueOf(treeEntry.getKey().toString()));
                result = new StringBuilder(24 + string3.length() + string4.length()).append(string3).append("    Tree ").append(n).append(": \n").append(string4).append("\n").toString();
                result = String.valueOf(result).concat("        Variables closed:\n");
                for (Symbol.VarSymbol var : treeEntry.getValue()) {
                    String string5 = String.valueOf(result);
                    String string6 = String.valueOf(String.valueOf(var.toString()));
                    result = new StringBuilder(12 + string5.length() + string6.length()).append(string5).append("            ").append(string6).toString();
                }
                result = String.valueOf(result).concat("\n");
                ++i;
            }
        }
        return result;
    }
}

