/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class ClassFinder {
    protected static final Context.Key<ClassFinder> classFinderKey = new Context.Key();
    ClassReader reader;
    Annotate annotate;
    boolean verbose;
    private boolean cacheCompletionFailure;
    protected boolean preferSource;
    protected boolean userPathsFirst;
    final Log log;
    Symtab syms;
    final Names names;
    final Name completionFailureName;
    private final JavaFileManager fileManager;
    private final Dependencies dependencies;
    JCDiagnostic.Factory diagFactory;
    public Symbol.Completer sourceCompleter = null;
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    private final Symbol.Completer thisCompleter = new Symbol.Completer(){

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            ClassFinder.this.complete(sym);
        }
    };
    private Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, (JCDiagnostic)null);
    protected JavaFileManager.Location currentLoc;
    private boolean verbosePath;
    private boolean preferCurrent;

    public Symbol.Completer getCompleter() {
        return this.thisCompleter;
    }

    public static ClassFinder instance(Context context) {
        ClassFinder instance = context.get(classFinderKey);
        if (instance == null) {
            instance = new ClassFinder(context);
        }
        return instance;
    }

    protected ClassFinder(Context context) {
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
        this.verbosePath = true;
        context.put(classFinderKey, this);
        this.reader = ClassReader.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.dependencies = Dependencies.instance(context);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.annotate = Annotate.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.cacheCompletionFailure = options.isUnset("dev");
        this.preferSource = "source".equals(options.get("-Xprefer"));
        this.userPathsFirst = options.isSet(Option.XXUSERPATHSFIRST);
        this.completionFailureName = options.isSet("failcomplete") ? this.names.fromString(options.get("failcomplete")) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (sym.kind == 2) {
            try {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
                this.dependencies.push(c);
                c.members_field = new Scope.ErrorScope(c);
                this.annotate.enterStart();
                try {
                    this.completeOwners(c.owner);
                    this.completeEnclosing(c);
                }
                finally {
                    this.annotate.enterDoneWithoutFlush();
                }
                this.fillIn(c);
            }
            finally {
                this.dependencies.pop();
            }
        }
        if (sym.kind == 1) {
            Symbol.PackageSymbol p = (Symbol.PackageSymbol)sym;
            try {
                this.fillIn(p);
            }
            catch (IOException ex) {
                throw new Symbol.CompletionFailure(sym, ex.getLocalizedMessage()).initCause(ex);
            }
        }
        if (!this.reader.filling) {
            this.annotate.flush();
        }
    }

    private void completeOwners(Symbol o) {
        if (o.kind != 1) {
            this.completeOwners(o.owner);
        }
        o.complete();
    }

    private void completeEnclosing(Symbol.ClassSymbol c) {
        if (c.owner.kind == 1) {
            Symbol owner = c.owner;
            for (Name name : Convert.enclosingCandidates(Convert.shortName(c.name))) {
                Symbol encl = owner.members().findFirst(name);
                if (encl == null) {
                    encl = this.syms.classes.get(Symbol.TypeSymbol.formFlatName(name, owner));
                }
                if (encl == null) continue;
                encl.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillIn(Symbol.ClassSymbol c) {
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure((Symbol)c, "user-selected completion failure by class name");
        }
        this.currentOwner = c;
        JavaFileObject classfile = c.classfile;
        if (classfile != null) {
            JavaFileObject previousClassFile = this.currentClassFile;
            try {
                String string;
                if (this.reader.filling) {
                    string = String.valueOf(String.valueOf(classfile.toUri()));
                    String string2 = String.valueOf(String.valueOf(previousClassFile));
                    Assert.error(new StringBuilder(16 + string.length() + string2.length()).append("Filling ").append(string).append(" during ").append(string2).toString());
                }
                this.currentClassFile = classfile;
                if (this.verbose) {
                    this.log.printVerbose("loading", this.currentClassFile.toString());
                }
                if (classfile.getKind() == JavaFileObject.Kind.CLASS) {
                    this.reader.readClassFile(c);
                }
                if (this.sourceCompleter != null) {
                    this.sourceCompleter.complete(c);
                }
                string = String.valueOf(String.valueOf(classfile.toUri()));
                throw new IllegalStateException(new StringBuilder(34 + string.length()).append("Source completer required to read ").append(string).toString());
            }
            finally {
                this.currentClassFile = previousClassFile;
            }
        } else {
            JCDiagnostic diag = this.diagFactory.fragment("class.file.not.found", c.flatname);
            throw this.newCompletionFailure(c, diag);
        }
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.TypeSymbol c, JCDiagnostic diag) {
        if (!this.cacheCompletionFailure) {
            return new Symbol.CompletionFailure((Symbol)c, diag);
        }
        Symbol.CompletionFailure result = this.cachedCompletionFailure;
        result.sym = c;
        result.diag = diag;
        return result;
    }

    public Symbol.ClassSymbol loadClass(Name flatname) throws Symbol.CompletionFailure {
        boolean absent = this.syms.classes.get(flatname) == null;
        Symbol.ClassSymbol c = this.syms.enterClass(flatname);
        if (c.members_field == null && c.completer != null) {
            try {
                c.complete();
            }
            catch (Symbol.CompletionFailure ex) {
                if (absent) {
                    this.syms.classes.remove(flatname);
                }
                throw ex;
            }
        }
        return c;
    }

    protected void includeClassFile(Symbol.PackageSymbol p, JavaFileObject file) {
        Symbol.ClassSymbol c;
        JavaFileObject.Kind kind;
        if ((p.flags_field & 0x800000L) == 0L) {
            Symbol q = p;
            while (q != null && q.kind == 1) {
                q.flags_field |= 0x800000L;
                q = q.owner;
            }
        }
        int seen = (kind = file.getKind()) == JavaFileObject.Kind.CLASS ? 0x2000000 : 0x4000000;
        String binaryName = this.fileManager.inferBinaryName(this.currentLoc, file);
        int lastDot = binaryName.lastIndexOf(".");
        Name classname = this.names.fromString(binaryName.substring(lastDot + 1));
        boolean isPkgInfo = classname == this.names.package_info;
        Symbol.ClassSymbol classSymbol = c = isPkgInfo ? p.package_info : (Symbol.ClassSymbol)p.members_field.findFirst(classname);
        if (c == null) {
            c = this.syms.enterClass(classname, p);
            if (c.classfile == null) {
                c.classfile = file;
            }
            if (isPkgInfo) {
                p.package_info = c;
            } else if (c.owner == p) {
                p.members_field.enter(c);
            }
        } else if (!this.preferCurrent && c.classfile != null && (c.flags_field & (long)seen) == 0L && (c.flags_field & 0x6000000L) != 0L) {
            c.classfile = this.preferredFileObject(file, c.classfile);
        }
        c.flags_field |= (long)seen;
    }

    protected JavaFileObject preferredFileObject(JavaFileObject a, JavaFileObject b) {
        long bdate;
        if (this.preferSource) {
            return a.getKind() == JavaFileObject.Kind.SOURCE ? a : b;
        }
        long adate = a.getLastModified();
        return adate > (bdate = b.getLastModified()) ? a : b;
    }

    protected EnumSet<JavaFileObject.Kind> getPackageFileKinds() {
        return EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);
    }

    protected void extraFileActions(Symbol.PackageSymbol pack, JavaFileObject fe) {
    }

    private void fillIn(Symbol.PackageSymbol p) throws IOException {
        if (p.members_field == null) {
            p.members_field = Scope.WriteableScope.create(p);
        }
        this.preferCurrent = false;
        if (this.userPathsFirst) {
            this.scanUserPaths(p);
            this.preferCurrent = true;
            this.scanPlatformPath(p);
        } else {
            this.scanPlatformPath(p);
            this.scanUserPaths(p);
        }
        this.verbosePath = false;
    }

    private void scanUserPaths(Symbol.PackageSymbol p) throws IOException {
        EnumSet<JavaFileObject.Kind> kinds = this.getPackageFileKinds();
        EnumSet<JavaFileObject.Kind> classKinds = EnumSet.copyOf(kinds);
        classKinds.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean wantClassFiles = !classKinds.isEmpty();
        EnumSet<JavaFileObject.Kind> sourceKinds = EnumSet.copyOf(kinds);
        sourceKinds.remove((Object)JavaFileObject.Kind.CLASS);
        boolean wantSourceFiles = !sourceKinds.isEmpty();
        boolean haveSourcePath = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH);
        if (this.verbose && this.verbosePath && this.fileManager instanceof StandardJavaFileManager) {
            List<Object> path;
            StandardJavaFileManager fm = (StandardJavaFileManager)this.fileManager;
            if (haveSourcePath && wantSourceFiles) {
                path = List.nil();
                for (File file : fm.getLocation(StandardLocation.SOURCE_PATH)) {
                    path = path.prepend(file);
                }
                this.log.printVerbose("sourcepath", path.reverse().toString());
            } else if (wantSourceFiles) {
                path = List.nil();
                for (File file : fm.getLocation(StandardLocation.CLASS_PATH)) {
                    path = path.prepend(file);
                }
                this.log.printVerbose("sourcepath", path.reverse().toString());
            }
            if (wantClassFiles) {
                path = List.nil();
                for (File file : fm.getLocation(StandardLocation.PLATFORM_CLASS_PATH)) {
                    path = path.prepend(file);
                }
                for (File file : fm.getLocation(StandardLocation.CLASS_PATH)) {
                    path = path.prepend(file);
                }
                this.log.printVerbose("classpath", path.reverse().toString());
            }
        }
        String packageName = p.fullname.toString();
        if (wantSourceFiles && !haveSourcePath) {
            this.fillIn(p, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, packageName, kinds, false));
        } else {
            if (wantClassFiles) {
                this.fillIn(p, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, packageName, classKinds, false));
            }
            if (wantSourceFiles) {
                this.fillIn(p, StandardLocation.SOURCE_PATH, this.fileManager.list(StandardLocation.SOURCE_PATH, packageName, sourceKinds, false));
            }
        }
    }

    private void scanPlatformPath(Symbol.PackageSymbol p) throws IOException {
        this.fillIn(p, StandardLocation.PLATFORM_CLASS_PATH, this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, p.fullname.toString(), EnumSet.of(JavaFileObject.Kind.CLASS), false));
    }

    private void fillIn(Symbol.PackageSymbol p, JavaFileManager.Location location, Iterable<JavaFileObject> files) {
        this.currentLoc = location;
        block3: for (JavaFileObject fo : files) {
            switch (fo.getKind()) {
                case CLASS: 
                case SOURCE: {
                    String binaryName = this.fileManager.inferBinaryName(this.currentLoc, fo);
                    String simpleName = binaryName.substring(binaryName.lastIndexOf(".") + 1);
                    if (!SourceVersion.isIdentifier(simpleName) && !simpleName.equals("package-info")) continue block3;
                    this.includeClassFile(p, fo);
                    continue block3;
                }
            }
            this.extraFileActions(p, fo);
        }
    }

    public static class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.TypeSymbol sym, JavaFileObject file, JCDiagnostic diag, JCDiagnostic.Factory diagFactory) {
            super((Symbol)sym, BadClassFile.createBadClassFileDiagnostic(file, diag, diagFactory));
        }

        private static JCDiagnostic createBadClassFileDiagnostic(JavaFileObject file, JCDiagnostic diag, JCDiagnostic.Factory diagFactory) {
            String key = file.getKind() == JavaFileObject.Kind.SOURCE ? "bad.source.file.header" : "bad.class.file.header";
            return diagFactory.fragment(key, file, diag);
        }
    }
}

