/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.file;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.javax.lang.model.SourceVersion;
import org.openjdk.javax.tools.FileObject;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.javax.tools.StandardJavaFileManager;
import org.openjdk.javax.tools.StandardLocation;
import org.openjdk.tools.javac.file.BaseFileManager;
import org.openjdk.tools.javac.file.FSInfo;
import org.openjdk.tools.javac.file.JRTIndex;
import org.openjdk.tools.javac.file.Locations;
import org.openjdk.tools.javac.file.PathFileObject;
import org.openjdk.tools.javac.file.RelativePath;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JDK9Wrappers;
import org.openjdk.tools.javac.util.ListBuffer;

public class JavacFileManager
extends BaseFileManager
implements StandardJavaFileManager {
    private FSInfo fsInfo;
    private final Set<JavaFileObject.Kind> sourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    protected boolean symbolFileEnabled;
    private StandardJavaFileManager.PathFactory pathFactory = Paths::get;
    protected SortFiles sortFiles;
    private final Map<Path, Container> containers = new HashMap<Path, Container>();
    private static final Container MISSING_CONTAINER = new Container(){

        @Override
        public void list(Path path, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) throws IOException {
        }

        @Override
        public JavaFileObject getFileObject(Path path, RelativePath.RelativeFile relativeFile) throws IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
        }
    };
    private JRTIndex jrtIndex;
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';

    public static char[] toArray(CharBuffer charBuffer) {
        if (charBuffer.hasArray()) {
            return ((CharBuffer)charBuffer.compact().flip()).array();
        }
        return charBuffer.toString().toCharArray();
    }

    public static void preRegister(Context context2) {
        context2.put(JavaFileManager.class, context -> new JavacFileManager(context, true, null));
    }

    public JavacFileManager(Context context, boolean bl, Charset charset) {
        super(charset);
        if (bl) {
            context.put(JavaFileManager.class, this);
        }
        this.setContext(context);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.fsInfo = FSInfo.instance(context);
        this.symbolFileEnabled = !this.options.isSet("ignore.symbol.file");
        String string = this.options.get("sortFiles");
        if (string != null) {
            this.sortFiles = string.equals("reverse") ? SortFiles.REVERSE : SortFiles.FORWARD;
        }
    }

    @Override
    public void setPathFactory(StandardJavaFileManager.PathFactory pathFactory) {
        this.pathFactory = Objects.requireNonNull(pathFactory);
        this.locations.setPathFactory(pathFactory);
    }

    private Path getPath(String string, String ... stringArray) {
        return this.pathFactory.getPath(string, stringArray);
    }

    public void setSymbolFileEnabled(boolean bl) {
        this.symbolFileEnabled = bl;
    }

    public boolean isSymbolFileEnabled() {
        return this.symbolFileEnabled;
    }

    public JavaFileObject getJavaFileObject(String string) {
        return this.getJavaFileObjects(string).iterator().next();
    }

    public JavaFileObject getJavaFileObject(Path path) {
        return this.getJavaFileObjects(path).iterator().next();
    }

    public JavaFileObject getFileForOutput(String string, JavaFileObject.Kind kind, JavaFileObject javaFileObject) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, string, kind, javaFileObject);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> iterable) {
        ListBuffer<Path> listBuffer = new ListBuffer<Path>();
        for (String string : iterable) {
            listBuffer.append(this.getPath(JavacFileManager.nullCheck(string), new String[0]));
        }
        return this.getJavaFileObjectsFromPaths(listBuffer.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... stringArray) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList((Object[])JavacFileManager.nullCheck(stringArray)));
    }

    private static boolean isValidName(String string) {
        for (String string2 : string.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String string) {
        if (!JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid class name: " + string);
        }
    }

    private static void validatePackageName(String string) {
        if (string.length() > 0 && !JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid packageName name: " + string);
        }
    }

    public static void testName(String string, boolean bl, boolean bl2) {
        try {
            JavacFileManager.validatePackageName(string);
            if (!bl) {
                throw new AssertionError((Object)("Invalid package name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl) {
                throw new AssertionError((Object)("Valid package name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", string);
        }
        try {
            JavacFileManager.validateClassName(string);
            if (!bl2) {
                throw new AssertionError((Object)("Invalid class name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl2) {
                throw new AssertionError((Object)("Valid class name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", string);
        }
    }

    private static void printAscii(String string, Object ... objectArray) {
        String string2;
        try {
            string2 = new String(String.format(null, string, objectArray).getBytes("US-ASCII"), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        System.out.println(string2);
    }

    synchronized Container getContainer(Path path) throws IOException {
        Container container = this.containers.get(path);
        if (container != null) {
            return container;
        }
        if (this.fsInfo.isFile(path) && path.equals(Locations.thisSystemModules)) {
            container = new JRTImageContainer();
            this.containers.put(path, container);
            return container;
        }
        Path path2 = this.fsInfo.getCanonicalFile(path);
        container = this.containers.get(path2);
        if (container != null) {
            this.containers.put(path, container);
            return container;
        }
        BasicFileAttributes basicFileAttributes = null;
        try {
            basicFileAttributes = Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException iOException) {
            container = MISSING_CONTAINER;
        }
        if (basicFileAttributes != null) {
            if (basicFileAttributes.isDirectory()) {
                container = new DirectoryContainer(path);
            } else {
                try {
                    container = new ArchiveContainer(path);
                }
                catch (SecurityException | ProviderNotFoundException runtimeException) {
                    throw new IOException(runtimeException);
                }
            }
        }
        this.containers.put(path2, container);
        this.containers.put(path, container);
        return container;
    }

    private synchronized JRTIndex getJRTIndex() {
        if (this.jrtIndex == null) {
            this.jrtIndex = JRTIndex.getSharedInstance();
        }
        return this.jrtIndex;
    }

    private boolean isValidFile(String string, Set<JavaFileObject.Kind> set) {
        JavaFileObject.Kind kind = JavacFileManager.getKind(string);
        return set.contains((Object)kind);
    }

    private boolean caseMapCheck(Path path, RelativePath relativePath) {
        char c;
        String string;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            string = path.toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
            c = path.getFileSystem().getSeparator().charAt(0);
        }
        catch (IOException iOException) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = relativePath.path.toCharArray();
        int n = cArray.length - 1;
        int n2 = cArray2.length - 1;
        while (n >= 0 && n2 >= 0) {
            while (n >= 0 && cArray[n] == c) {
                --n;
            }
            while (n2 >= 0 && cArray2[n2] == '/') {
                --n2;
            }
            if (n < 0 || n2 < 0) continue;
            if (cArray[n] != cArray2[n2]) {
                return false;
            }
            --n;
            --n2;
        }
        return n2 < 0;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.deferredCloseTimeout > 0L) {
            this.deferredClose();
            return;
        }
        this.locations.close();
        for (Container container : this.containers.values()) {
            container.close();
        }
        this.containers.clear();
        this.contentCache.clear();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        this.checkNotModuleOrientedLocation(location);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        ListBuffer<URL> listBuffer = new ListBuffer<URL>();
        for (File file : iterable) {
            try {
                listBuffer.append(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return this.getClassLoader(listBuffer.toArray(new URL[listBuffer.size()]));
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        this.checkNotModuleOrientedLocation(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(set);
        Iterable<? extends Path> iterable = this.getLocationAsPaths(location);
        if (iterable == null) {
            return org.openjdk.tools.javac.util.List.nil();
        }
        RelativePath.RelativeDirectory relativeDirectory = RelativePath.RelativeDirectory.forPackage(string);
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (Path path : iterable) {
            Container container = this.getContainer(path);
            container.list(path, relativeDirectory, set, bl, listBuffer);
        }
        return listBuffer.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        this.checkNotModuleOrientedLocation(location);
        Objects.requireNonNull(javaFileObject);
        Iterable<? extends Path> iterable = this.getLocationAsPaths(location);
        if (iterable == null) {
            return null;
        }
        if (javaFileObject instanceof PathFileObject) {
            return ((PathFileObject)javaFileObject).inferBinaryName(iterable);
        }
        throw new IllegalArgumentException(javaFileObject.getClass().getName());
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        JavacFileManager.nullCheck(fileObject);
        JavacFileManager.nullCheck(fileObject2);
        if (fileObject instanceof PathFileObject && fileObject2 instanceof PathFileObject) {
            return ((PathFileObject)fileObject).isSameFile((PathFileObject)fileObject2);
        }
        return fileObject.equals(fileObject2);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        this.checkNotModuleOrientedLocation(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForInput(location, RelativePath.RelativeFile.forClass(string, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        this.checkNotModuleOrientedLocation(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(string2)) {
            throw new IllegalArgumentException("Invalid relative name: " + string2);
        }
        RelativePath.RelativeFile relativeFile = string.length() == 0 ? new RelativePath.RelativeFile(string2) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(string), string2);
        return this.getFileForInput(location, relativeFile);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, RelativePath.RelativeFile relativeFile) throws IOException {
        Iterable<? extends Path> iterable = this.getLocationAsPaths(location);
        if (iterable == null) {
            return null;
        }
        for (Path path : iterable) {
            JavaFileObject javaFileObject = this.getContainer(path).getFileObject(path, relativeFile);
            if (javaFileObject == null) continue;
            return javaFileObject;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        this.checkOutputLocation(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, RelativePath.RelativeFile.forClass(string, kind), fileObject);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        this.checkOutputLocation(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(string2)) {
            throw new IllegalArgumentException("Invalid relative name: " + string2);
        }
        RelativePath.RelativeFile relativeFile = string.length() == 0 ? new RelativePath.RelativeFile(string2) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(string), string2);
        return this.getFileForOutput(location, relativeFile, fileObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, RelativePath.RelativeFile relativeFile, FileObject fileObject) throws IOException {
        Path path;
        block10: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    path = this.getClassOutDir();
                    break block10;
                } else {
                    String string = relativeFile.basename();
                    if (fileObject != null && fileObject instanceof PathFileObject) {
                        return ((PathFileObject)fileObject).getSibling(string);
                    }
                    Path path2 = this.getPath(string, new String[0]);
                    Path path3 = this.fsInfo.getCanonicalFile(path2);
                    return PathFileObject.forSimplePath(this, path3, path2);
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                path = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                Collection<Path> collection = this.locations.getLocation(location);
                path = null;
                Iterator iterator = collection.iterator();
                if (iterator.hasNext()) {
                    Path path4;
                    path = path4 = (Path)iterator.next();
                }
            }
        }
        try {
            if (path == null) {
                path = this.getPath(System.getProperty("user.dir"), new String[0]);
            }
            Path path5 = relativeFile.resolveAgainst(this.fsInfo.getCanonicalFile(path));
            return PathFileObject.forDirectoryPath(this, path5, path, relativeFile);
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("bad filename " + relativeFile, invalidPathException);
        }
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> iterable) {
        ArrayList<PathFileObject> arrayList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<PathFileObject>();
        for (File file : iterable) {
            Objects.requireNonNull(file);
            Path path = file.toPath();
            arrayList.add(PathFileObject.forSimplePath(this, this.fsInfo.getCanonicalFile(path), path));
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> iterable) {
        ArrayList<PathFileObject> arrayList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<PathFileObject>();
        for (Path path : iterable) {
            arrayList.add(PathFileObject.forSimplePath(this, this.fsInfo.getCanonicalFile(path), path));
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... fileArray) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList((Object[])JavacFileManager.nullCheck(fileArray)));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... pathArray) {
        return this.getJavaFileObjectsFromPaths(Arrays.asList((Object[])JavacFileManager.nullCheck(pathArray)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, JavacFileManager.asPaths(iterable));
    }

    @Override
    public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> collection) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, JavacFileManager.nullCheck(collection));
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return JavacFileManager.asFiles(this.locations.getLocation(location));
    }

    @Override
    public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.getLocation(location);
    }

    private Path getClassOutDir() {
        return this.locations.getOutputLocation(StandardLocation.CLASS_OUTPUT);
    }

    private Path getSourceOutDir() {
        return this.locations.getOutputLocation(StandardLocation.SOURCE_OUTPUT);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String string) throws IOException {
        this.checkModuleOrientedOrOutputLocation(location);
        JavacFileManager.nullCheck(string);
        if (location == StandardLocation.SOURCE_OUTPUT && this.getSourceOutDir() == null) {
            location = StandardLocation.CLASS_OUTPUT;
        }
        return this.locations.getLocationForModule(location, string);
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> clazz) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(clazz);
        JDK9Wrappers.Module.getModule(this.getClass()).addUses(clazz);
        if (location.isModuleOrientedLocation()) {
            Collection<Path> collection = this.locations.getLocation(location);
            JDK9Wrappers.ModuleFinder moduleFinder = JDK9Wrappers.ModuleFinder.of(collection.toArray(new Path[collection.size()]));
            JDK9Wrappers.Layer layer = JDK9Wrappers.Layer.boot();
            JDK9Wrappers.Configuration configuration = layer.configuration().resolveAndBind(JDK9Wrappers.ModuleFinder.of(new Path[0]), moduleFinder, Collections.emptySet());
            JDK9Wrappers.Layer layer2 = layer.defineModulesWithOneLoader(configuration, ClassLoader.getSystemClassLoader());
            return JDK9Wrappers.ServiceLoaderHelper.load(layer2, clazz);
        }
        return ServiceLoader.load(clazz, this.getClassLoader(location));
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject javaFileObject) throws IOException {
        this.checkModuleOrientedOrOutputLocation(location);
        if (!(javaFileObject instanceof PathFileObject)) {
            return null;
        }
        Path path = Locations.normalize(((PathFileObject)javaFileObject).path);
        return this.locations.getLocationForModule(location, path);
    }

    @Override
    public void setLocationForModule(JavaFileManager.Location location, String string, Collection<? extends Path> collection) throws IOException {
        JavacFileManager.nullCheck(location);
        this.checkModuleOrientedOrOutputLocation(location);
        this.locations.setLocationForModule(location, JavacFileManager.nullCheck(string), JavacFileManager.nullCheck(collection));
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) {
        this.checkNotModuleOrientedLocation(location);
        return this.locations.inferModuleName(location);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        this.checkModuleOrientedOrOutputLocation(location);
        return this.locations.listLocationsForModules(location);
    }

    @Override
    public Path asPath(FileObject fileObject) {
        if (fileObject instanceof PathFileObject) {
            return ((PathFileObject)fileObject).path;
        }
        throw new IllegalArgumentException(fileObject.getName());
    }

    protected static boolean isRelativeUri(URI uRI) {
        if (uRI.isAbsolute()) {
            return false;
        }
        String string = uRI.normalize().getPath();
        if (string.length() == 0) {
            return false;
        }
        if (!string.equals(uRI.getPath())) {
            return false;
        }
        return !string.startsWith("/") && !string.startsWith("./") && !string.startsWith("../");
    }

    protected static boolean isRelativeUri(String string) {
        try {
            return JavacFileManager.isRelativeUri(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static String getRelativeName(File file) {
        String string;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(string = file.getPath().replace(File.separatorChar, '/'))) {
            return string;
        }
        throw new IllegalArgumentException("Invalid relative path: " + file);
    }

    public static String getMessage(IOException iOException) {
        String string = iOException.getLocalizedMessage();
        if (string != null) {
            return string;
        }
        string = iOException.getMessage();
        if (string != null) {
            return string;
        }
        return iOException.toString();
    }

    private void checkOutputLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException("location is not an output location: " + location.getName());
        }
    }

    private void checkModuleOrientedOrOutputLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (!location.isModuleOrientedLocation() && !location.isOutputLocation()) {
            throw new IllegalArgumentException("location is not an output location or a module-oriented location: " + location.getName());
        }
    }

    private void checkNotModuleOrientedLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (location.isModuleOrientedLocation()) {
            throw new IllegalArgumentException("location is module-oriented: " + location.getName());
        }
    }

    private static Iterable<Path> asPaths(final Iterable<? extends File> iterable) {
        if (iterable == null) {
            return null;
        }
        return () -> new Iterator<Path>(){
            Iterator iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Path next() {
                return ((File)this.iter.next()).toPath();
            }
        };
    }

    private static Iterable<File> asFiles(final Iterable<? extends Path> iterable) {
        if (iterable == null) {
            return null;
        }
        return () -> new Iterator<File>(){
            Iterator iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public File next() {
                try {
                    return ((Path)this.iter.next()).toFile();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw new IllegalStateException(unsupportedOperationException);
                }
            }
        };
    }

    private final class ArchiveContainer
    implements Container {
        private final Path archivePath;
        private final FileSystem fileSystem;
        private final Map<RelativePath, Path> packages;

        public ArchiveContainer(Path path) throws IOException, ProviderNotFoundException, SecurityException {
            this.archivePath = path;
            if (JavacFileManager.this.multiReleaseValue != null && path.toString().endsWith(".jar")) {
                Map<String, String> map = Collections.singletonMap("multi-release", JavacFileManager.this.multiReleaseValue);
                FileSystemProvider object = JavacFileManager.this.fsInfo.getJarFSProvider();
                Assert.checkNonNull(object, "should have been caught before!");
                this.fileSystem = object.newFileSystem(path, map);
            } else {
                this.fileSystem = FileSystems.newFileSystem(path, null);
            }
            this.packages = new HashMap<RelativePath, Path>();
            for (final Path path2 : this.fileSystem.getRootDirectories()) {
                Files.walkFileTree(path2, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                        if (ArchiveContainer.this.isValid(path.getFileName())) {
                            ArchiveContainer.this.packages.put(new RelativePath.RelativeDirectory(path2.relativize(path).toString()), path);
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                });
            }
        }

        @Override
        public void list(Path path, RelativePath.RelativeDirectory relativeDirectory, final Set<JavaFileObject.Kind> set, boolean bl, final ListBuffer<JavaFileObject> listBuffer) throws IOException {
            Path path2 = this.packages.get(relativeDirectory);
            if (path2 == null) {
                return;
            }
            int n = bl ? Integer.MAX_VALUE : 1;
            EnumSet<FileVisitOption> enumSet = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            Files.walkFileTree(path2, enumSet, n, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                    if (ArchiveContainer.this.isValid(path.getFileName())) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                    if (basicFileAttributes.isRegularFile() && set.contains((Object)BaseFileManager.getKind(path.getFileName().toString()))) {
                        PathFileObject pathFileObject = PathFileObject.forJarPath(JavacFileManager.this, path, ArchiveContainer.this.archivePath);
                        listBuffer.append(pathFileObject);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private boolean isValid(Path path) {
            if (path == null) {
                return true;
            }
            String string = path.toString();
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            return SourceVersion.isIdentifier(string);
        }

        @Override
        public JavaFileObject getFileObject(Path path, RelativePath.RelativeFile relativeFile) throws IOException {
            Path path2;
            RelativePath.RelativeDirectory relativeDirectory = relativeFile.dirname();
            Path path3 = this.packages.get(relativeDirectory);
            if (path3 != null && Files.exists(path2 = path3.resolve(relativeFile.basename()), new LinkOption[0])) {
                return PathFileObject.forJarPath(JavacFileManager.this, path2, path);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.fileSystem.close();
        }
    }

    private final class DirectoryContainer
    implements Container {
        private final Path directory;

        public DirectoryContainer(Path path) {
            this.directory = path;
        }

        @Override
        public void list(Path path, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) throws IOException {
            List list;
            Path path2;
            try {
                path2 = relativeDirectory.resolveAgainst(path);
            }
            catch (InvalidPathException invalidPathException) {
                return;
            }
            if (!Files.exists(path2, new LinkOption[0])) {
                return;
            }
            if (!JavacFileManager.this.caseMapCheck(path2, relativeDirectory)) {
                return;
            }
            try {
                Stream<Path> stream = Files.list(path2);
                Object object = null;
                try {
                    list = (JavacFileManager.this.sortFiles == null ? stream : stream.sorted(JavacFileManager.this.sortFiles)).collect(Collectors.toList());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (object != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                return;
            }
            for (Object object : list) {
                String string = object.getFileName().toString();
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (Files.isDirectory((Path)object, new LinkOption[0])) {
                    if (!bl || !SourceVersion.isIdentifier(string)) continue;
                    this.list(path, new RelativePath.RelativeDirectory(relativeDirectory, string), set, bl, listBuffer);
                    continue;
                }
                if (!JavacFileManager.this.isValidFile(string, set)) continue;
                RelativePath.RelativeFile relativeFile = new RelativePath.RelativeFile(relativeDirectory, string);
                PathFileObject pathFileObject = PathFileObject.forDirectoryPath(JavacFileManager.this, relativeFile.resolveAgainst(this.directory), path, relativeFile);
                listBuffer.append(pathFileObject);
            }
        }

        @Override
        public JavaFileObject getFileObject(Path path, RelativePath.RelativeFile relativeFile) throws IOException {
            try {
                Path path2 = relativeFile.resolveAgainst(path);
                if (Files.exists(path2, new LinkOption[0])) {
                    return PathFileObject.forSimplePath(JavacFileManager.this, JavacFileManager.this.fsInfo.getCanonicalFile(path2), path2);
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private final class JRTImageContainer
    implements Container {
        private JRTImageContainer() {
        }

        @Override
        public void list(Path path, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) throws IOException {
            try {
                JRTIndex.Entry entry = JavacFileManager.this.getJRTIndex().getEntry(relativeDirectory);
                if (JavacFileManager.this.symbolFileEnabled && entry.ctSym.hidden) {
                    return;
                }
                for (Path comparable : entry.files.values()) {
                    if (!set.contains((Object)BaseFileManager.getKind(comparable))) continue;
                    PathFileObject pathFileObject = PathFileObject.forJRTPath(JavacFileManager.this, comparable);
                    listBuffer.append(pathFileObject);
                }
                if (bl) {
                    for (RelativePath.RelativeDirectory relativeDirectory2 : entry.subdirs) {
                        this.list(path, relativeDirectory2, set, bl, listBuffer);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                JavacFileManager.this.log.error("error.reading.file", path, JavacFileManager.getMessage(iOException));
            }
        }

        @Override
        public JavaFileObject getFileObject(Path path, RelativePath.RelativeFile relativeFile) throws IOException {
            JRTIndex.Entry entry = JavacFileManager.this.getJRTIndex().getEntry(relativeFile.dirname());
            if (JavacFileManager.this.symbolFileEnabled && entry.ctSym.hidden) {
                return null;
            }
            Path path2 = entry.files.get(relativeFile.basename());
            if (path2 != null) {
                return PathFileObject.forJRTPath(JavacFileManager.this, path2);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static interface Container {
        public void list(Path var1, RelativePath.RelativeDirectory var2, Set<JavaFileObject.Kind> var3, boolean var4, ListBuffer<JavaFileObject> var5) throws IOException;

        public JavaFileObject getFileObject(Path var1, RelativePath.RelativeFile var2) throws IOException;

        public void close() throws IOException;
    }

    protected static enum SortFiles implements Comparator<Path>
    {
        FORWARD{

            @Override
            public int compare(Path path, Path path2) {
                return path.getFileName().compareTo(path2.getFileName());
            }
        }
        ,
        REVERSE{

            @Override
            public int compare(Path path, Path path2) {
                return -path.getFileName().compareTo(path2.getFileName());
            }
        };

    }
}

