/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.gcpkms;

import com.google.api.services.cloudkms.v1.CloudKMS;
import com.google.api.services.cloudkms.v1.model.DecryptRequest;
import com.google.api.services.cloudkms.v1.model.DecryptResponse;
import com.google.api.services.cloudkms.v1.model.EncryptRequest;
import com.google.api.services.cloudkms.v1.model.EncryptResponse;
import com.google.crypto.tink.Aead;
import java.io.IOException;
import java.security.GeneralSecurityException;

public final class GcpKmsAead
implements Aead {
    private final CloudKMS kmsClient;
    private final String kmsKeyUri;

    public GcpKmsAead(CloudKMS kmsClient, String keyUri) throws GeneralSecurityException {
        this.kmsClient = kmsClient;
        this.kmsKeyUri = keyUri;
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] aad) throws GeneralSecurityException {
        try {
            EncryptRequest request = new EncryptRequest().encodePlaintext(plaintext).encodeAdditionalAuthenticatedData(aad);
            EncryptResponse response = (EncryptResponse)this.kmsClient.projects().locations().keyRings().cryptoKeys().encrypt(this.kmsKeyUri, request).execute();
            return response.decodeCiphertext();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("encryption failed", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] aad) throws GeneralSecurityException {
        try {
            DecryptRequest request = new DecryptRequest().encodeCiphertext(ciphertext).encodeAdditionalAuthenticatedData(aad);
            DecryptResponse response = (DecryptResponse)this.kmsClient.projects().locations().keyRings().cryptoKeys().decrypt(this.kmsKeyUri, request).execute();
            return response.decodePlaintext();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("decryption failed", e);
        }
    }
}

