/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.sbt.compiler.sbt013;

import com.google.code.sbt.compiler.api.CompilerLogger;
import com.google.code.sbt.compiler.api.DefaultSourcePosition;
import com.google.code.sbt.compiler.api.SourcePosition;
import com.google.code.sbt.compiler.api.SourcePositionMapper;
import com.google.code.sbt.compiler.sbt013.SBT013Position;
import java.io.File;
import scala.runtime.AbstractFunction1;
import xsbti.Maybe;
import xsbti.Position;

public class SBT013SourcePositionMapper
extends AbstractFunction1<Position, Position> {
    private SourcePositionMapper mapper;
    private CompilerLogger logger;

    public SBT013SourcePositionMapper(SourcePositionMapper mapper, CompilerLogger logger) {
        this.mapper = mapper;
        this.logger = logger;
    }

    public Position apply(Position position) {
        Position result = position;
        if (this.mapper != null) {
            Maybe line = position.line();
            String lineContent = position.lineContent();
            Maybe offset = position.offset();
            Maybe pointer = position.pointer();
            Maybe sourceFile = position.sourceFile();
            DefaultSourcePosition sp = new DefaultSourcePosition(line.isDefined() ? (Integer)line.get() : -1, lineContent, offset.isDefined() ? (Integer)offset.get() : -1, pointer.isDefined() ? (Integer)pointer.get() : -1, sourceFile.isDefined() ? (File)sourceFile.get() : null);
            try {
                SourcePosition mappedPosition = this.mapper.map((SourcePosition)sp);
                if (mappedPosition != null) {
                    result = new SBT013Position(mappedPosition);
                }
            }
            catch (Throwable t) {
                this.logger.debug(t);
            }
        }
        return result;
    }
}

