/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.sbt.compiler.sbt013;

import com.google.code.sbt.compiler.api.SourcePosition;
import java.io.File;
import xsbti.Maybe;
import xsbti.Position;

public class SBT013Position
implements Position {
    private SourcePosition sourcePosition;

    public SBT013Position(SourcePosition sourcePosition) {
        this.sourcePosition = sourcePosition;
    }

    public Maybe<Integer> line() {
        int line = this.sourcePosition.getLine();
        return line > 0 ? Maybe.just((Object)line) : Maybe.nothing();
    }

    public String lineContent() {
        String lineContent = this.sourcePosition.getLineContent();
        return lineContent != null ? lineContent : "";
    }

    public Maybe<Integer> offset() {
        int offset = this.sourcePosition.getOffset();
        return offset >= 0 ? Maybe.just((Object)offset) : Maybe.nothing();
    }

    public Maybe<Integer> pointer() {
        int column = this.sourcePosition.getPointer();
        return column > 0 ? Maybe.just((Object)column) : Maybe.nothing();
    }

    public Maybe<String> pointerSpace() {
        String pointerSpace = null;
        int col = this.sourcePosition.getPointer();
        String content = this.sourcePosition.getLineContent();
        if (col > 0 && content != null) {
            int pointerSpaceLength = Math.min(col, content.length());
            StringBuilder sb = new StringBuilder(pointerSpaceLength);
            for (int i = 0; i < pointerSpaceLength; ++i) {
                sb.append(content.charAt(i) == '\t' ? (char)'\t' : ' ');
            }
            pointerSpace = sb.toString();
        }
        return pointerSpace != null ? Maybe.just(pointerSpace) : Maybe.nothing();
    }

    public Maybe<String> sourcePath() {
        File sourceFile = this.sourcePosition.getFile();
        return sourceFile != null ? Maybe.just((Object)sourceFile.getAbsolutePath()) : Maybe.nothing();
    }

    public Maybe<File> sourceFile() {
        File sourceFile = this.sourcePosition.getFile();
        return sourceFile != null ? Maybe.just((Object)sourceFile) : Maybe.nothing();
    }
}

