/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.sbt.compiler.sbt013;

import com.google.code.sbt.compiler.api.CompilerLogger;
import xsbti.F0;
import xsbti.Logger;

public class SBT013Logger
implements Logger {
    private static final String MISLEADING_WARNING_MESSAGE = "Pruning sources from previous analysis, due to incompatible CompileSetup.";
    private CompilerLogger compilerLogger;
    private StringBuilder errors = new StringBuilder();

    public SBT013Logger(CompilerLogger compilerLogger) {
        this.compilerLogger = compilerLogger;
    }

    public void error(F0<String> msg) {
        if (this.compilerLogger.isErrorEnabled()) {
            String msgString = (String)msg.apply();
            this.errors.append(msgString).append('\n');
            this.compilerLogger.error(msgString);
        }
    }

    public void warn(F0<String> msg) {
        String msgString;
        if (this.compilerLogger.isWarnEnabled() && !MISLEADING_WARNING_MESSAGE.equals(msgString = (String)msg.apply())) {
            this.compilerLogger.warn(msgString);
        }
    }

    public void info(F0<String> msg) {
        if (this.compilerLogger.isInfoEnabled()) {
            this.compilerLogger.info((String)msg.apply());
        }
    }

    public void debug(F0<String> msg) {
        if (this.compilerLogger.isDebugEnabled()) {
            this.compilerLogger.debug((String)msg.apply());
        }
    }

    public void trace(F0<Throwable> exception) {
        if (this.compilerLogger.isDebugEnabled()) {
            this.compilerLogger.debug((Throwable)exception.apply());
        }
    }

    String[] getConsoleErrorLines() {
        return this.errors.toString().split("\n");
    }
}

