/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.sbt.compiler.api;

import java.io.File;

public class Compilers {
    private static final String CLASSES = "classes";
    private static final String TEST_CLASSES = "test-classes";
    private static final String CACHE = "cache";

    private Compilers() {
    }

    public static String getDefaultCompilerId(String sbtVersion, String playVersion) {
        String result = null;
        if (sbtVersion != null && !sbtVersion.isEmpty()) {
            if (sbtVersion.equals("0.13") || sbtVersion.startsWith("0.13.")) {
                result = "sbt013";
            } else if (sbtVersion.equals("0.12") || sbtVersion.startsWith("0.12.")) {
                result = "sbt012";
            }
        }
        if (result == null && playVersion != null && !playVersion.isEmpty() && (playVersion.startsWith("2.1.") || playVersion.startsWith("2.1-"))) {
            result = "sbt012";
        }
        if (result == null) {
            result = "sbt013";
        }
        return result;
    }

    public static File getCacheDirectory(File classesDirectory) {
        String classesDirectoryName = classesDirectory.getName();
        String cacheDirectoryName = classesDirectoryName.replace(TEST_CLASSES, CACHE).replace(CLASSES, CACHE);
        return new File(classesDirectory.getParentFile(), cacheDirectoryName);
    }
}

