/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.sbt.compiler.api;

import com.google.code.sbt.compiler.api.Compiler;
import com.google.code.sbt.compiler.api.CompilerConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public abstract class AbstractCompiler
implements Compiler {
    protected List<String> resolveScalacOptions(CompilerConfiguration configuration) {
        String scalacOptions = configuration.getScalacOptions();
        String sourceEncoding = configuration.getSourceEncoding();
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(this.parseArgLine(scalacOptions)));
        if (!result.contains("-encoding") && sourceEncoding != null && sourceEncoding.length() > 0) {
            result.add("-encoding");
            result.add(sourceEncoding);
        }
        return result;
    }

    protected List<String> resolveJavacOptions(CompilerConfiguration configuration) {
        String javacOptions = configuration.getJavacOptions();
        String sourceEncoding = configuration.getSourceEncoding();
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(this.parseArgLine(javacOptions)));
        if (!result.contains("-encoding") && sourceEncoding != null && sourceEncoding.length() > 0) {
            result.add("-encoding");
            result.add(sourceEncoding);
        }
        return result;
    }

    private String[] parseArgLine(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add(current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + toProcess);
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }
}

