/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.provider.play27;

import com.google.code.play2.provider.api.AssetCompilationException;
import com.google.code.play2.provider.api.LessCompilationResult;
import com.google.code.play2.provider.api.Play2LessCompiler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class Play27LessCompiler
implements Play2LessCompiler {
    public static final String LESS_SCRIPT = "less-1.4.2.js";

    public void setCompilerOptions(List<String> compilerOptions) {
    }

    public LessCompilationResult compile(File source) throws AssetCompilationException, IOException {
        try {
            InternalCompileResult result1 = this.compile(source, false);
            InternalCompileResult result2 = this.compile(source, true);
            return new CompileResult(result1.css, result2.css, result1.dependencies);
        }
        catch (JavaScriptException e) {
            Scriptable error = (Scriptable)e.getValue();
            String filename = ScriptableObject.getProperty((Scriptable)error, (String)"filename").toString();
            File file = new File(filename);
            throw new AssetCompilationException((Throwable)e, file, ScriptableObject.getProperty((Scriptable)error, (String)"message").toString(), ((Double)ScriptableObject.getProperty((Scriptable)error, (String)"line")).intValue(), ((Double)ScriptableObject.getProperty((Scriptable)error, (String)"column")).intValue());
        }
    }

    private String multiLineString(String[] lines) {
        StringBuilder sb = new StringBuilder();
        if (lines != null && lines.length > 0) {
            sb.append(lines[0]);
            for (int i = 1; i < lines.length; ++i) {
                sb.append("\n");
                sb.append(lines[i]);
            }
        }
        return sb.toString();
    }

    private InternalCompileResult compile(File source, boolean minify) throws IOException {
        Context ctx = Context.enter();
        Global global = new Global();
        global.init(ctx);
        Scriptable scope = ctx.initStandardObjects((ScriptableObject)global);
        Object wrappedLessCompiler = Context.javaToJS((Object)this, (Scriptable)scope);
        ScriptableObject.putProperty((Scriptable)scope, (String)"LessCompiler", (Object)wrappedLessCompiler);
        ctx.evaluateString(scope, this.multiLineString(new String[]{"", "                var timers = [],", "                    window = {", "                        document: {", "                            getElementById: function(id) { ", "                                return [];", "                            },", "                            getElementsByTagName: function(tagName) {", "                                return [];", "                            }", "                        },", "                        location: {", "                            protocol: 'file:', ", "                            hostname: 'localhost', ", "                            port: '80'", "                        },", "                        setInterval: function(fn, time) {", "                            var num = timers.length;", "                            timers[num] = fn.call(this, null);", "                            return num;", "                        }", "                    },", "                    document = window.document,", "                    location = window.location,", "                    setInterval = window.setInterval;", "", "            "}), "browser.js", 1, null);
        ctx.evaluateReader(scope, (Reader)new InputStreamReader(this.getClass().getClassLoader().getResource(LESS_SCRIPT).openConnection().getInputStream(), "UTF-8"), LESS_SCRIPT, 1, null);
        ctx.evaluateString(scope, this.multiLineString(new String[]{"                var compile = function(source) {", "", "                    var compiled;", "                    // Import tree context", "                    var context = [source];", "                    var dependencies = [source];", "", "                    window.less.Parser.importer = function(path, paths, fn, env) {", "", "                        var imported = LessCompiler.resolve(context[context.length - 1], path);", "                        var importedName = String(imported.getCanonicalPath());", "                        try {", "                          var input = String(LessCompiler.readContent(imported));", "                        } catch (e) {", "                          return fn({ type: \"File\", message: \"File not found: \" + importedName });", "                        }", "", "                        // Store it in the contents, for error reporting", "                        env.contents[importedName] = input;", "", "                        context.push(imported);", "                        dependencies.push(imported)", "", "                        new(window.less.Parser)({", "                            optimization:3,", "                            filename:importedName,", "                            contents:env.contents,", "                            dumpLineNumbers:window.less.dumpLineNumbers", "                        }).parse(input, function (e, root) {", "                            fn(e, root, input);", "", "                            context.pop();", "                        });", "                    }", "", "                    new(window.less.Parser)({optimization:3, filename:String(source.getCanonicalPath())}).parse(String(LessCompiler.readContent(source)), function (e,root) {", "                        if (e) {", "                            throw e;", "                        }", "                        compiled = root.toCSS({compress: " + (minify ? "true" : "false") + "})", "                    })", "", "                    return {css:compiled, dependencies:dependencies}", "                }", "            "}), "compiler.js", 1, null);
        Function compilerFunction = (Function)scope.get("compile", scope);
        Context.exit();
        Scriptable result = (Scriptable)Context.call(null, (Callable)compilerFunction, (Scriptable)scope, (Scriptable)scope, (Object[])new Object[]{source});
        String css = ScriptableObject.getProperty((Scriptable)result, (String)"css").toString();
        NativeArray dependencies = (NativeArray)ScriptableObject.getProperty((Scriptable)result, (String)"dependencies");
        int dependenciesCount = Long.valueOf(dependencies.getLength()).intValue();
        ArrayList<File> deps = new ArrayList<File>(dependenciesCount);
        int i = 0;
        while ((long)i < dependencies.getLength()) {
            Object dependency = ScriptableObject.getProperty((Scriptable)dependencies, (int)i);
            if (dependency instanceof File) {
                deps.add(((File)dependency).getCanonicalFile());
            } else if (dependency instanceof NativeJavaObject) {
                Object x = ((NativeJavaObject)dependency).unwrap();
                deps.add(((File)x).getCanonicalFile());
            }
            ++i;
        }
        return new InternalCompileResult(css, deps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readContent(File file) throws IOException {
        String result = null;
        try (BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            StringBuilder sb = new StringBuilder();
            String line = is.readLine();
            while (line != null) {
                sb.append(line).append('\n');
                line = is.readLine();
            }
            result = sb.toString();
        }
        return result;
    }

    public static File resolve(File originalSource, String imported) {
        return new File(originalSource.getParentFile(), imported);
    }

    public static class CompileResult
    extends InternalCompileResult
    implements LessCompilationResult {
        private String minifiedCss;

        public CompileResult(String css, String minifiedCss, List<File> dependencies) {
            super(css, dependencies);
            this.minifiedCss = minifiedCss;
        }

        public String getMinifiedCss() {
            return this.minifiedCss;
        }
    }

    private static class InternalCompileResult {
        private String css;
        private List<File> dependencies;

        InternalCompileResult(String css, List<File> dependencies) {
            this.css = css;
            this.dependencies = dependencies;
        }

        public String getCss() {
            return this.css;
        }

        public List<File> getDependencies() {
            return this.dependencies;
        }
    }
}

